/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal.html.html5.wizard;

import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.jst.web.ui.JSTWebUIImages;
import org.jboss.tools.jst.web.ui.palette.html.wizard.HTMLConstants;
import org.jboss.tools.jst.web.ui.palette.html.wizard.NewHTMLWidgetWizard;
import org.jboss.tools.jst.web.ui.palette.internal.html.html5.wizard.NewTableWizardPage;

public class NewTableWizard
extends NewHTMLWidgetWizard<NewTableWizardPage>
implements HTMLConstants {
    public NewTableWizard() {
        this.setWindowTitle(DropWizardMessages.Wizard_Window_Title);
        this.setDefaultPageImageDescriptor(JSTWebUIImages.getInstance().getOrCreateImageDescriptor(JSTWebUIImages.TABLE_IMAGE));
    }

    @Override
    protected NewTableWizardPage createPage() {
        return new NewTableWizardPage();
    }

    @Override
    protected void addContent(IElementGenerator.ElementNode parent) {
        int i;
        IElementGenerator.ElementNode table = parent.addChild("table");
        this.addID("table-", table);
        String caption = ((NewTableWizardPage)this.page).getEditorValue("caption");
        if (caption.length() > 0) {
            table.addChild("caption", caption);
        }
        boolean isAdvanced = "Advanced".equals(((NewTableWizardPage)this.page).getEditorValue("table-kind"));
        IElementGenerator.ElementNode tr = null;
        if (this.isTrue("thead")) {
            IElementGenerator.ElementNode thead = isAdvanced ? table.addChild("thead") : table;
            tr = thead.addChild("tr");
            i = 0;
            while (i < ((NewTableWizardPage)this.page).columns.getNumber()) {
                String columnName = ((NewTableWizardPage)this.page).columns.getColumnName(i);
                tr.addChild("th", columnName);
                ++i;
            }
        }
        IElementGenerator.ElementNode tbody = isAdvanced ? table.addChild("tbody") : table;
        tr = tbody.addChild("tr");
        i = 0;
        while (i < ((NewTableWizardPage)this.page).columns.getNumber()) {
            String firstRowContent = ((NewTableWizardPage)this.page).columns.getContent(i);
            tr.addChild("td", firstRowContent);
            ++i;
        }
        if (isAdvanced && this.isTrue("tfoot")) {
            IElementGenerator.ElementNode thead = table.addChild("tfoot");
            tr = thead.addChild("tr");
            int i2 = 0;
            while (i2 < ((NewTableWizardPage)this.page).columns.getNumber()) {
                String columnName = ((NewTableWizardPage)this.page).columns.getFooterContent(i2);
                tr.addChild("th", columnName);
                ++i2;
            }
        }
    }

    @Override
    protected void createBodyForBrowser(IElementGenerator.ElementNode body) {
        IElementGenerator.ElementNode form = this.getFormNode(body);
        IElementGenerator.ElementNode div = form.addChild("div");
        div.addAttribute("style", "padding: 20px 20px 20px 20px;");
        this.addContent(div);
    }
}

