/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal.html.impl;

import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.jboss.tools.jst.web.ui.WebUiPlugin;

public class PaletteCountManager {
    private static PaletteCountManager instance = new PaletteCountManager();
    private Hashtable<IProject, ProjectCounts> projectMap = new Hashtable();

    public static PaletteCountManager getInstance() {
        return instance;
    }

    private ProjectCounts getProjectCounts(IProject project) {
        ProjectCounts projectCounts = this.projectMap.get(project);
        if (projectCounts == null) {
            projectCounts = new ProjectCounts(project);
            this.projectMap.put(project, projectCounts);
        }
        return projectCounts;
    }

    public long getCountIndex(IProject project, String id) {
        ProjectCounts projectCounts = this.getProjectCounts(project);
        return projectCounts.getCountIndex(id);
    }

    public void setCountIndex(IProject project, String id, long count) {
        ProjectCounts projectCounts = this.getProjectCounts(project);
        projectCounts.setCountIndex(id, count);
    }

    public void setProjectCountIndex(IProject project, long count) {
        ProjectCounts projectCounts = this.getProjectCounts(project);
        projectCounts.setProjectCountIndex(count);
    }

    public long getNumberOfCalls(IProject project, String id) {
        ProjectCounts projectCounts = this.getProjectCounts(project);
        return projectCounts.getNumberOfCalls(id);
    }

    public void setNumberOfCalls(IProject project, String id, long numberOfCalls) {
        ProjectCounts projectCounts = this.getProjectCounts(project);
        projectCounts.setNumberOfCalls(id, numberOfCalls);
    }

    public void called(IProject project, String id) {
        ProjectCounts projectCounts = this.getProjectCounts(project);
        projectCounts.called(id);
    }

    public void load(IProject project, String id) {
        ProjectCounts projectCounts = this.getProjectCounts(project);
        projectCounts.load(id);
    }

    public void save(IProject project, String id) {
        ProjectCounts projectCounts = this.getProjectCounts(project);
        projectCounts.save(id);
    }

    public void saveAll(IProject project) {
        ProjectCounts projectCounts = this.getProjectCounts(project);
        projectCounts.saveAll();
    }

    static class IdCounts {
        private String id;
        private ProjectCounts projectCounts;
        private long countIndex;
        private long numberOfCalls;

        public IdCounts(ProjectCounts projectCounts, String id) {
            this.projectCounts = projectCounts;
            this.id = id;
            this.load();
        }

        public long getCountIndex() {
            return this.countIndex;
        }

        public void setCountIndex(long countIndex) {
            this.countIndex = countIndex;
            if (countIndex > this.projectCounts.getProjectCountIndex()) {
                this.projectCounts.setProjectCountIndex(countIndex);
            }
        }

        public long getNumberOfCalls() {
            return this.numberOfCalls;
        }

        public void setNumberOfCalls(long numberOfCalls) {
            this.numberOfCalls = numberOfCalls;
        }

        public void called() {
            ++this.numberOfCalls;
            long projectCountIndex = this.projectCounts.getProjectCountIndex();
            this.countIndex = ++projectCountIndex;
            this.projectCounts.setProjectCountIndex(projectCountIndex);
        }

        public void load() {
            try {
                String countString = this.projectCounts.getProject().getPersistentProperty(new QualifiedName("org.jboss.tools.jst.web.ui", this.id));
                if (countString != null) {
                    StringTokenizer st = new StringTokenizer(countString, " ");
                    this.countIndex = new Long(st.nextToken());
                    if (this.countIndex > this.projectCounts.getProjectCountIndex()) {
                        this.projectCounts.setProjectCountIndex(this.countIndex);
                    }
                    this.numberOfCalls = new Long(st.nextToken());
                }
            }
            catch (CoreException e) {
                WebUiPlugin.getDefault().logError(e);
            }
        }

        public void save() {
            try {
                this.projectCounts.getProject().setPersistentProperty(new QualifiedName("org.jboss.tools.jst.web.ui", this.id), this.countIndex + " " + this.numberOfCalls);
            }
            catch (CoreException e) {
                WebUiPlugin.getDefault().logError(e);
            }
        }
    }

    static class ProjectCounts {
        private IProject project;
        private Hashtable<String, IdCounts> idMap = new Hashtable();
        private long projectCountIndex;

        public ProjectCounts(IProject project) {
            this.project = project;
        }

        public long getProjectCountIndex() {
            return this.projectCountIndex;
        }

        public void setProjectCountIndex(long count) {
            this.projectCountIndex = count;
        }

        private IdCounts getIdCounts(String id) {
            IdCounts idCounts = this.idMap.get(id);
            if (idCounts == null) {
                idCounts = new IdCounts(this, id);
                this.idMap.put(id, idCounts);
            }
            return idCounts;
        }

        public IProject getProject() {
            return this.project;
        }

        public long getCountIndex(String id) {
            IdCounts idCounts = this.getIdCounts(id);
            return idCounts.getCountIndex();
        }

        public void setCountIndex(String id, long count) {
            IdCounts idCounts = this.getIdCounts(id);
            idCounts.setCountIndex(count);
        }

        public long getNumberOfCalls(String id) {
            IdCounts idCounts = this.getIdCounts(id);
            return idCounts.getNumberOfCalls();
        }

        public void setNumberOfCalls(String id, long numberOfCalls) {
            IdCounts idCounts = this.getIdCounts(id);
            idCounts.setNumberOfCalls(numberOfCalls);
        }

        public void called(String id) {
            IdCounts idCounts = this.getIdCounts(id);
            idCounts.called();
        }

        public void load(String id) {
            IdCounts idCounts = this.getIdCounts(id);
            idCounts.load();
        }

        public void save(String id) {
            IdCounts idCounts = this.getIdCounts(id);
            idCounts.save();
        }

        public void saveAll() {
            for (IdCounts ic : this.idMap.values()) {
                ic.save();
            }
        }
    }
}

