/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.browser.wtp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.IClient;
import org.eclipse.wst.server.core.internal.ILaunchableAdapter;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.util.HttpLaunchable;
import org.eclipse.wst.server.core.util.WebResource;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.ModelFeatureFactory;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.browser.AbstractBrowserContext;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.server.ServerManager;

public class RunOnServerContext
extends AbstractBrowserContext {
    static RunOnServerContext instance = new RunOnServerContext();
    static String[][] pathSources = new String[][]{{"org.jboss.tools.jst.web.model.handlers.RunOnServerHandler", "org.jboss.tools.jst.web"}, {"org.jboss.tools.jsf.model.handlers.run.RunOnServerHandler", "org.jboss.tools.jsf"}};

    @Override
    public void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        int i = 0;
        while (i < pathSources.length) {
            String plugin = pathSources[i][1];
            if (Platform.getBundle((String)plugin) != null) {
                String classname = pathSources[i][0];
                ModelFeatureFactory.getInstance().createFeatureInstance(classname);
            }
            ++i;
        }
    }

    public static RunOnServerContext getInstance() {
        return instance;
    }

    @Override
    public String getModelActionPath() {
        return "RunActions.RunPageOnServer";
    }

    @Override
    public String getBrowserPrefix(XModel model) {
        URL url;
        IServer server = ServerManager.getInstance().getSelectedServer();
        if (server == null) {
            return "%server%" + WebUIMessages.CANNOT_RUN_SELECTION_WITHOUT_AVAILABLE_SERVER;
        }
        IProject p = EclipseResourceUtil.getProject((XModelObject)model.getRoot());
        if (!(p == null || p.exists() && p.isOpen())) {
            p = null;
        }
        if (p == null) {
            return null;
        }
        IModule ms = null;
        try {
            ms = ServerUtil.getModule((IProject)p);
        }
        catch (Exception e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
        WebResource wr = ms == null ? null : new WebResource(ms, (IPath)new Path(""));
        HttpLaunchable launchable = this.getLaunchable(server, wr);
        if (launchable != null && (url = launchable.getURL()) != null) {
            return url.toString();
        }
        return "%server%" + NLS.bind((String)WebUIMessages.APPLICATION_ISNOT_REGISTERED_IN_SELECTED_SERVER, (Object)(p == null ? "" : p.getName()));
    }

    private HttpLaunchable getLaunchable(IServer server, WebResource resource) {
        if (resource == null) {
            return null;
        }
        ILaunchableAdapter[] as = ServerPlugin.getLaunchableAdapters();
        int i = 0;
        while (i < as.length) {
            try {
                Object launchable = as[i].getLaunchable(server, (IModuleArtifact)resource);
                if (launchable instanceof HttpLaunchable) {
                    return (HttpLaunchable)launchable;
                }
            }
            catch (CoreException e) {
                WebModelPlugin.getPluginLog().logError((Throwable)e);
            }
            ++i;
        }
        return null;
    }

    @Override
    protected void doExecute(String lastRunUrl) throws XModelException {
        ServiceDialog d = PreferenceModelUtilities.getPreferenceModel().getService();
        final IServer server = ServerManager.getInstance().getSelectedServer();
        if (server == null) {
            if (lastRunUrl != null && lastRunUrl.startsWith("%server%")) {
                String message = WebUIMessages.PLEASE_CREATE_A_SERVER_AND_SELECT_IT_ON_TOOLBAR;
                d.showDialog(WebUIMessages.WARNING, message, new String[]{WebUIMessages.CLOSE}, null, 2);
                return;
            }
            this.runJustUrl();
            return;
        }
        if (!this.checkUrl()) {
            return;
        }
        server.getModules();
        final String launchMode = "debug".equals(server.getMode()) ? "debug" : "run";
        try {
            final HttpLaunchable launchable = new HttpLaunchable(new URL(lastRunUrl));
            IClient[] clients = RunOnServerContext.getClients(server, launchable, launchMode);
            final IClient client = clients[0];
            if (server.getLaunch() == null) {
                server.start(launchMode, new IServer.IOperationListener(){

                    public void done(IStatus result) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                client.launch(server, launchable, launchMode, server.getLaunch());
                            }
                        });
                    }
                });
                return;
            }
            client.launch(server, (Object)launchable, launchMode, server.getLaunch());
        }
        catch (MalformedURLException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
            this.runJustUrl();
        }
    }

    public static IClient[] getClients(IServer server, Object launchable, String launchMode) {
        ArrayList<IClient> list = new ArrayList<IClient>();
        IClient[] clients = ServerPlugin.getClients();
        if (clients != null) {
            int size = clients.length;
            int i = 0;
            while (i < size) {
                if (clients[i].supports(server, launchable, launchMode)) {
                    list.add(clients[i]);
                }
                ++i;
            }
        }
        IClient[] clients2 = new IClient[list.size()];
        list.toArray(clients2);
        return clients2;
    }

    @Override
    public void runJustUrl() {
        IWorkbenchBrowserSupport browserSupport = ModelPlugin.getDefault().getWorkbench().getBrowserSupport();
        try {
            IWebBrowser browser = browserSupport.createBrowser(6, null, null, null);
            if (!this.checkUrl()) {
                return;
            }
            browser.openURL(new URL(this.lastRunUrl));
        }
        catch (MalformedURLException mue) {
            ServiceDialog d = PreferenceModelUtilities.getPreferenceModel().getService();
            d.showDialog(WebUIMessages.ERROR, NLS.bind((String)WebUIMessages.INCORRECT_URL, (Object)mue.getMessage()), new String[]{WebUIMessages.OK}, null, 1);
        }
        catch (PartInitException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private boolean checkUrl() {
        if (this.lastRunUrl == null || this.lastRunUrl.length() == 0) {
            return false;
        }
        if (!this.lastRunUrl.startsWith("%server%")) {
            return true;
        }
        if (this.lastRunObject == null) {
            return false;
        }
        ServiceDialog d = PreferenceModelUtilities.getPreferenceModel().getService();
        XModelObject fss = this.lastRunObject.getModel().getByPath("FileSystems");
        if (fss == null) {
            return false;
        }
        String appname = fss.getAttributeValue("application name");
        String message = NLS.bind((String)WebUIMessages.APPLICATION_ISNOT_REGISTERED_IN_SELECTED_SERVER, (Object)appname);
        d.showDialog(WebUIMessages.WARNING, message, new String[]{WebUIMessages.CLOSE}, null, 2);
        return false;
    }
}

