/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.context;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.context.ImportWebProjectContext;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.project.WebModuleImpl;

public abstract class ImportWebWarContext
extends ImportWebProjectContext {
    protected String warLocation = null;
    protected String customerLocation;
    protected String warError;
    protected String nameError;
    protected ZipFile zip = null;
    protected Set<String> entries = new HashSet<String>();
    protected boolean isClassicEclipseProject = true;
    protected String[] originalSources;

    public void setCustomerLocation(String location) {
        this.customerLocation = location;
    }

    public String getProjectLocation() {
        IProject p = this.getProjectHandle();
        return p == null || p.getLocation() == null ? null : p.getLocation().toString();
    }

    @Override
    public String getSuggestedProjectLocation() {
        return this.customerLocation;
    }

    public void setWarLocation(String location) {
        if (location.equals(this.warLocation)) {
            return;
        }
        this.entries.clear();
        this.warError = null;
        this.warLocation = location;
        if (this.warLocation.length() == 0) {
            this.warError = WebUIMessages.WAR_LOCATION_MUST_BE_SET;
            return;
        }
        File f = new File(location);
        if (!f.isFile()) {
            this.warError = NLS.bind((String)WebUIMessages.FILE_DOESNOT_EXIST_P, (Object)location);
            return;
        }
        try {
            this.zip = new ZipFile(f);
            this.loadEntries();
        }
        catch (ZipException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
            this.warError = NLS.bind((String)WebUIMessages.FILE_ISNOT_CORRECT, (Object)location);
            return;
        }
        catch (IOException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
            this.warError = NLS.bind((String)WebUIMessages.FILE_ISNOT_CORRECT, (Object)location);
            return;
        }
        ZipEntry entry = null;
        try {
            entry = this.zip.getEntry("WEB-INF/web.xml");
        }
        catch (IllegalStateException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
        if (entry == null) {
            this.warError = NLS.bind((String)WebUIMessages.FILE_DOESNOT_CONTAIN_WEBXML, (Object)location);
            return;
        }
        String body = null;
        try {
            InputStream s = this.zip.getInputStream(entry);
            body = FileUtil.readStream((InputStream)s);
        }
        catch (ZipException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
            this.warError = NLS.bind((String)WebUIMessages.CANNOT_READ_WEBXML, (Object)location);
            return;
        }
        catch (IOException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
            this.warError = NLS.bind((String)WebUIMessages.CANNOT_READ_WEBXML, (Object)location);
            return;
        }
        try {
            this.loadWebXML(body, "WEB-INF/web.xml");
        }
        catch (XModelException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
            this.warError = e.getMessage();
            return;
        }
        this.warError = null;
        String name = f.getName();
        if (name.lastIndexOf(46) > 0) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        if (name.length() > 0) {
            name = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        }
        this.setProjectName(name);
        this.setServletVersion(this.getWebXMLVersion());
    }

    @Override
    public void setProjectName(String value) {
        IStatus nameStatus;
        if (this.projectName != null && this.projectName.equals(value)) {
            return;
        }
        super.setProjectName(value);
        this.registry.setApplicationName(value);
        this.nameError = value == null || value.length() == 0 ? WebUIMessages.NAME_MUST_BE_SET : (!(nameStatus = ModelPlugin.getWorkspace().validateName(this.projectName, 4)).isOK() ? nameStatus.getMessage() : (this.getProjectHandle() != null && this.getProjectHandle().exists() ? NLS.bind((String)WebUIMessages.PROJECT_ALREADY_EXISTS_IN_THE_WORKSPACE, (Object)value) : (EclipseResourceUtil.projectExistsIgnoreCase((String)this.projectName) ? NLS.bind((String)WebUIMessages.PROJECT_ALREADY_EXISTS_IN_THE_WORKSPACE, (Object)value) : null)));
        this.projectName = value;
    }

    private void loadEntries() {
        Enumeration<? extends ZipEntry> en = this.zip.entries();
        block0: while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            String n = entry.getName();
            this.entries.add(n);
            while (true) {
                int i;
                if (n.endsWith("/")) {
                    n = n.substring(0, n.length() - 1);
                }
                if ((i = n.lastIndexOf("/")) < 0 || this.entries.contains(n = n.substring(0, i + 1))) continue block0;
                this.entries.add(n);
            }
        }
    }

    public String getWarLocation() {
        return this.warLocation;
    }

    public String getErrorMessage() {
        if (this.warLocation == null) {
            this.setWarLocation("");
        }
        if (this.warError != null) {
            return this.warError;
        }
        if (this.nameError != null) {
            return this.nameError;
        }
        return this.registry.getErrorMessage();
    }

    public boolean canFinish() {
        return this.getErrorMessage() == null;
    }

    public void setClassicEclipseProject(boolean b) {
        this.isClassicEclipseProject = b;
    }

    public boolean isClassicEclipseProject() {
        return this.isClassicEclipseProject;
    }

    public void prepare() {
        String root = this.getSuggestedProjectLocation();
        this.setAddLibraries(false);
        this.setServletVersion("2.4");
        this.webInfLocation = !this.isClassicEclipseProject ? String.valueOf(root) + "/WEB-INF" : String.valueOf(root) + "/WebContent/WEB-INF";
        this.setClassesLocation(String.valueOf(this.webInfLocation) + "/classes");
        this.setLibLocation(String.valueOf(this.webInfLocation) + "/lib");
        this.webXmlLocation = String.valueOf(this.webInfLocation) + "/web.xml";
        this.findJavaSources();
        this.createModules();
    }

    public void prepareModules() {
        this.findJavaSources();
        this.createModules();
    }

    protected void createModules() {
    }

    protected void findJavaSources() {
        String root;
        String path;
        String[] ps = this.entries.toArray(new String[0]);
        HashSet<String> classes = new HashSet<String>();
        HashSet<String> js = new HashSet<String>();
        int i = 0;
        while (i < ps.length) {
            path = ps[i];
            if (path.endsWith(".class") && path.startsWith("WEB-INF/classes")) {
                String classname = path.substring("WEB-INF/classes/".length(), path.length() - ".class".length()).replace('/', '.');
                classes.add(classname);
            }
            ++i;
        }
        i = 0;
        while (i < ps.length) {
            path = ps[i];
            if (path.endsWith(".java")) {
                int k;
                path = path.substring(0, path.length() - ".java".length());
                String prefix = "";
                while ((k = path.indexOf(47)) >= 0) {
                    prefix = String.valueOf(prefix) + "/" + path.substring(0, k);
                    String cn = (path = path.substring(k + 1)).replace('/', '.');
                    if (!classes.contains(cn)) continue;
                    js.add(prefix);
                    break;
                }
            }
            ++i;
        }
        this.originalSources = js.toArray(new String[0]);
        if (this.originalSources.length == 0) {
            this.existingSources = new String[0];
            return;
        }
        String rootOriginal = root = this.getSuggestedProjectLocation();
        this.existingSources = new String[this.originalSources.length];
        if (this.isClassicEclipseProject) {
            rootOriginal = String.valueOf(rootOriginal) + "/WebContent";
            if (this.existingSources.length == 1) {
                this.existingSources[0] = this.originalSources[0].equals("/WEB-INF/classes") ? String.valueOf(rootOriginal) + this.originalSources[0] : String.valueOf(root) + "/JavaSource";
            } else {
                int i2 = 0;
                while (i2 < this.existingSources.length) {
                    String s = this.originalSources[i2];
                    this.existingSources[i2] = s.equals("/WEB-INF/classes") ? String.valueOf(root) + "/JavaSource" : String.valueOf(root) + "/" + s.substring(s.lastIndexOf(47) + 1);
                    ++i2;
                }
            }
        } else {
            int i3 = 0;
            while (i3 < this.existingSources.length) {
                this.existingSources[i3] = String.valueOf(root) + this.originalSources[i3];
                ++i3;
            }
        }
        int i4 = 0;
        while (i4 < this.originalSources.length) {
            this.originalSources[i4] = String.valueOf(rootOriginal) + this.originalSources[i4];
            ++i4;
        }
    }

    public String[] getOriginalSources() {
        return this.originalSources;
    }

    protected abstract String getWebModuleEntity();

    protected XModelObject createModuleInfo(XModel model, String name, String uri) {
        String loc = this.getWebInfLocation();
        String parent = loc.substring(0, loc.length() - "/WEB-INF".length());
        Properties p = new Properties();
        p.setProperty("name", name);
        p.setProperty("URI", uri);
        String path = this.getPathOnDisk(parent, "WEB-INF", uri);
        if (path != null) {
            p.setProperty("path on disk", path);
        }
        if (name.length() == 0) {
            String src;
            if ("WEB-INF".equals("WEB-INF") || path != null) {
                p.setProperty("root", parent);
            }
            if ((src = this.guessSrc()) != null) {
                p.setProperty("java src", src);
            }
        } else {
            String modulepath = String.valueOf(parent) + name;
            p.setProperty("root", modulepath);
            String src = this.guessSrc();
            if (src != null) {
                p.setProperty("java src", src);
            }
        }
        XModelObject o = model.createModelObject(this.getWebModuleEntity(), p);
        if (uri.indexOf(44) >= 0 && o instanceof WebModuleImpl) {
            ((WebModuleImpl)o).setURI(uri);
            StringTokenizer st = new StringTokenizer(uri, ",");
            if (st.hasMoreTokens()) {
                String t = st.nextToken().trim();
                path = this.getPathOnDisk(parent, "WEB-INF", t);
                if (path != null) {
                    o.setAttributeValue("path on disk", path);
                }
                while (st.hasMoreTokens()) {
                    t = st.nextToken().trim();
                    String cp = t.replace('/', '#');
                    XModelObject c = o.getChildByPath(cp);
                    path = this.getPathOnDisk(parent, "WEB-INF", t);
                    if (c == null || path == null) continue;
                    c.setAttributeValue("path on disk", path);
                }
            }
        }
        return o;
    }

    private String getPathOnDisk(String parent, String win, String uri) {
        String path = String.valueOf(parent) + uri;
        if (new File(path).isFile()) {
            return path;
        }
        if (uri.startsWith("/WEB-INF/") ? new File(path = String.valueOf(parent) + "/" + win + uri.substring(8)).isFile() : uri.startsWith("WEB-INF/") && new File(path = String.valueOf(parent) + "/" + win + uri.substring(7)).isFile()) {
            return path;
        }
        return null;
    }

    protected String guessSrc() {
        if (this.existingSources != null && this.existingSources.length > 0) {
            return this.existingSources[0];
        }
        return null;
    }
}

