/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.model;

import org.jboss.tools.common.meta.constraint.XProperty;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileAuxiliary;
import org.jboss.tools.common.model.filesystems.impl.AbstractExtendedXMLFileImpl;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.filesystems.impl.FolderLoader;
import org.jboss.tools.common.model.loaders.AuxiliaryLoader;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jst.web.model.WebProcessLoader;
import org.w3c.dom.Element;

public abstract class AbstractWebDiagramLoader
implements WebProcessLoader,
AuxiliaryLoader {
    protected FileAuxiliary aux = this.createFileAuxiliary();
    protected XModelObjectLoaderUtil util = this.createUtil();

    protected abstract FileAuxiliary createFileAuxiliary();

    protected abstract XModelObjectLoaderUtil createUtil();

    public abstract String serializeMainObject(XModelObject var1);

    protected void setEncoding(XModelObject object, String body) {
        String encoding = XModelObjectLoaderUtil.getEncoding((String)body);
        if (encoding == null) {
            encoding = "";
        }
        object.setAttributeValue("encoding", encoding);
    }

    public boolean update(XModelObject object) throws XModelException {
        XModelObject p = object.getParent();
        if (p == null) {
            return true;
        }
        FolderLoader fl = (FolderLoader)p;
        String body = fl.getBodySource(FileAnyImpl.toFileName((XProperty)object)).get();
        AbstractExtendedXMLFileImpl f = (AbstractExtendedXMLFileImpl)object;
        f.setUpdateLock();
        try {
            f.edit(body, true);
        }
        finally {
            f.releaseUpdateLock();
        }
        object.setModified(false);
        XModelObjectLoaderUtil.updateModifiedOnSave((XModelObject)object);
        return true;
    }

    public boolean save(XModelObject object) {
        if (!object.isModified()) {
            return true;
        }
        FileAnyImpl file = (FileAnyImpl)object;
        String text = file.getAsText();
        XModelObjectLoaderUtil.setTempBody((XModelObject)object, (String)text);
        if ("yes".equals(object.get("isIncorrect"))) {
            return true;
        }
        return this.saveLayout(object);
    }

    protected abstract boolean saveLayout(XModelObject var1);

    public void bind(XModelObject main) {
        this.aux.getAuxiliaryFile(main.getParent(), main, false);
    }

    public String mainObjectToString(XModelObject object) {
        return this.serializeMainObject(object);
    }

    public String serializeObject(XModelObject object) {
        return this.serializeMainObject(object);
    }

    public void loadFragment(XModelObject object, Element element) {
        this.util.load(element, object);
    }
}

