/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.project.handlers;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.action.impl.MultistepWizardStep;
import org.jboss.tools.common.meta.action.impl.MultistepWizardSupport;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.project.handlers.AddProjectTemplateSupport;
import org.jboss.tools.jst.web.project.handlers.EditProjectTemplateStep;
import org.jboss.tools.jst.web.project.helpers.AbstractWebProjectTemplate;
import org.jboss.tools.jst.web.project.helpers.ProjectTemplate;

public class EditProjectTemplateSupport
extends MultistepWizardSupport {
    AbstractWebProjectTemplate template;
    EditProjectTemplateStep step;
    ProjectTemplate projectTemplate;
    Set<String> templates;
    protected DefaultWizardDataValidator validator = new ProjectTemplateValidator();

    public static String run(AbstractWebProjectTemplate template, String entity, String version, String name) {
        String actionPath = "EditActions.EditProjectTemplate";
        Properties p = new Properties();
        p.put("version", version);
        p.put("name", name);
        return AddProjectTemplateSupport.run(template, entity, actionPath, p);
    }

    protected MultistepWizardStep[] createSteps() {
        MultistepWizardStep[] multistepWizardStepArray = new MultistepWizardStep[1];
        this.step = new EditProjectTemplateStep();
        multistepWizardStepArray[0] = this.step;
        return multistepWizardStepArray;
    }

    public void reset() {
        this.initSteps();
        this.template = (AbstractWebProjectTemplate)this.getProperties().get("template");
        String versionName = this.getProperties().getProperty("version");
        String name = this.getProperties().getProperty("name");
        this.projectTemplate = this.template.getProjectTemplate(versionName, name);
        this.getProperties().put("projectTemplate", this.projectTemplate);
        this.templates = new HashSet<String>();
        if (versionName != null) {
            String[] ts = this.template.getTemplateList(versionName);
            int i = 0;
            while (i < ts.length) {
                this.templates.add(ts[i]);
                ++i;
            }
        }
    }

    public void action(String name) throws XModelException {
        if (WebUIMessages.EditProjectTemplateSupport_Save.equals(name)) {
            name = FINISH;
        }
        super.action(name);
    }

    public String[] getActionNames(int stepId) {
        return new String[]{WebUIMessages.EditProjectTemplateSupport_Save, CANCEL};
    }

    protected void execute() throws XModelException {
        this.projectTemplate.commit();
        this.getProperties().setProperty("name", this.projectTemplate.getName());
    }

    public WizardDataValidator getValidator(int step) {
        if (step == 0) {
            this.validator.setSupport((SpecialWizardSupport)this, step);
            return this.validator;
        }
        return super.getValidator(step);
    }

    class ProjectTemplateValidator
    extends DefaultWizardDataValidator {
        ProjectTemplateValidator() {
        }

        public void validate(Properties data) {
            this.message = null;
            super.validate(data);
            if (this.message != null) {
                return;
            }
            String name = data.getProperty("name");
            if (EditProjectTemplateSupport.this.projectTemplate.isNameModified() && EditProjectTemplateSupport.this.templates.contains(name)) {
                this.message = NLS.bind((String)WebUIMessages.PROJECT_TEMPLATE_ALREADY_EXISTS, (Object)name);
                return;
            }
        }
    }
}

