/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.project.helpers;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.project.handlers.AddLibrarySetSupport;
import org.jboss.tools.jst.web.project.helpers.AbstractWebProjectTemplate;
import org.jboss.tools.jst.web.project.helpers.LibrarySet;

public class LibrarySets {
    static String[] installBundles = new String[]{"org.jboss.tools.jsf", "org.jboss.tools.common.model"};
    static LibrarySets instance = new LibrarySets();
    String libPath;
    Map<String, LibrarySet> librarySets = new TreeMap<String, LibrarySet>();

    LibrarySets() {
        this.loadInstallPath();
        this.refresh();
    }

    public static LibrarySets getInstance() {
        return instance;
    }

    public String getLibrarySetsPath() {
        return this.libPath;
    }

    private void loadInstallPath() {
        this.libPath = String.valueOf(WebModelPlugin.getTemplateStateLocation()) + "lib";
    }

    public void refresh() {
        File[] fs = new File(this.libPath).listFiles();
        if (fs == null) {
            this.librarySets.clear();
            return;
        }
        HashMap<String, String> fm = new HashMap<String, String>();
        int i = 0;
        while (i < fs.length) {
            if (fs[i].isDirectory() && !"CVS".equalsIgnoreCase(fs[i].getName()) && !".svn".equalsIgnoreCase(fs[i].getName())) {
                fm.put(fs[i].getName(), fs[i].getAbsolutePath());
            }
            ++i;
        }
        for (String name : this.librarySets.keySet()) {
            if (fm.containsKey(name)) continue;
            this.librarySets.remove(name);
        }
        for (String name : fm.keySet()) {
            LibrarySet s = this.getLibrarySet(name);
            if (s == null) {
                s = new LibrarySet(name, ((String)fm.get(name)).toString());
                this.librarySets.put(name, s);
            }
            s.refresh();
        }
    }

    public String[] getLibrarySetList() {
        return this.librarySets.keySet().toArray(new String[0]);
    }

    public LibrarySet getLibrarySet(String name) {
        return this.librarySets.get(name);
    }

    public String addLibrarySet() {
        return AddLibrarySetSupport.run();
    }

    public void addLibrarySet(String name) {
        if (this.getLibrarySet(name) != null) {
            return;
        }
        String path = String.valueOf(this.getLibrarySetsPath()) + "/" + name;
        File d = new File(path);
        d.mkdirs();
        if (d.isDirectory()) {
            LibrarySet s = new LibrarySet(name, path);
            s.refresh();
            this.librarySets.put(name, s);
        }
    }

    public boolean removeLibrarySet(String name) {
        LibrarySet s = this.getLibrarySet(name);
        if (s == null) {
            return false;
        }
        if (!AbstractWebProjectTemplate.confirm(NLS.bind((String)WebUIMessages.YOU_WANT_TO_DELETE_LIBRARYSET, (Object)name))) {
            return false;
        }
        String path = s.getPath();
        FileUtil.remove((File)new File(path));
        this.librarySets.remove(name);
        return true;
    }
}

