/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.project.helpers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.xml.XMLEntityResolver;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class WebAppConfig {
    public static final String TAG_SERVLET = "servlet";
    public static final String TAG_SERVLET_NAME = "servlet-name";
    public static final String TAG_SERVLET_CLASS = "servlet-class";
    public static final String TAG_INIT_PARAM = "init-param";
    public static final String TAG_PARAM_NAME = "param-name";
    public static final String TAG_PARAM_VALUE = "param-value";
    private Document conf;
    private Element webApp;

    static {
        try {
            Class<WebAppConfig> c = WebAppConfig.class;
            XMLEntityResolver.registerPublicEntity((String)"-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", (String)FileLocator.resolve((URL)c.getResource("/meta/web-app_2_2.dtd")).toString());
            XMLEntityResolver.registerPublicEntity((String)"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", (String)FileLocator.resolve((URL)c.getResource("/meta/web-app_2_3.dtd")).toString());
        }
        catch (IOException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public WebAppConfig() {
    }

    public WebAppConfig(File confFile) throws FileNotFoundException {
        this.load(confFile);
    }

    public void load(File confFile) throws FileNotFoundException {
        this.conf = XMLUtil.getDocument((Reader)new FileReader(confFile));
        this.webApp = this.conf.getDocumentElement();
    }

    public Element[] getServlets() {
        return XMLUtil.getChildren((Element)this.webApp, (String)TAG_SERVLET);
    }

    public Element getServletByName(String name) {
        Element[] servlets = this.getServlets();
        int i = 0;
        while (i < servlets.length) {
            String n = this.getTextElement(servlets[i], TAG_SERVLET_NAME);
            if (name.equals(n)) {
                return servlets[i];
            }
            ++i;
        }
        return null;
    }

    public Element[] getServletsByClass(String className) {
        Element[] servlets = this.getServlets();
        ArrayList<Element> list = new ArrayList<Element>(servlets.length);
        int i = 0;
        while (i < servlets.length) {
            String n = this.getTextElement(servlets[i], TAG_SERVLET_CLASS);
            if (className.equals(n)) {
                list.add(servlets[i]);
            }
            ++i;
        }
        return list.toArray(new Element[list.size()]);
    }

    public Element[] getInitParams(Element servlet) {
        return XMLUtil.getChildren((Element)servlet, (String)TAG_INIT_PARAM);
    }

    public Map<String, String> getInitParamsAsMap(Element servlet) {
        Element[] params = this.getInitParams(servlet);
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < params.length) {
            String name = this.getTextElement(params[i], TAG_PARAM_NAME);
            String value = this.getTextElement(params[i], TAG_PARAM_VALUE);
            map.put(name, value);
            ++i;
        }
        return map;
    }

    public String getTextElement(Element parent, String tag) {
        Node text;
        Element child = XMLUtil.getFirstChild((Element)parent, (String)tag);
        if (child != null && (text = child.getFirstChild()) != null) {
            return text.getNodeValue().trim();
        }
        return null;
    }
}

