/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tld.model;

import org.jboss.tools.common.model.loaders.EntityRecognizer;
import org.jboss.tools.common.model.loaders.EntityRecognizerContext;
import org.jboss.tools.common.model.loaders.XMLRecognizerContext;
import org.jboss.tools.common.xml.XMLEntityResolver;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.tld.model.TLDConstants;

public class FileTLDRecognizer
implements EntityRecognizer,
TLDConstants {
    static String VERSION_2_0;
    static String VERSION_2_1;
    static String XMLNS_2_0;
    static String XMLNS_2_1;

    static {
        try {
            XMLEntityResolver.registerPublicEntity((String)"-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN", FileTLDRecognizer.class, (String)"/meta/web-jsptaglibrary_1_1.dtd");
            XMLEntityResolver.registerPublicEntity((String)"-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN", FileTLDRecognizer.class, (String)"/meta/web-jsptaglibrary_1_2.dtd");
        }
        catch (Exception e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
        VERSION_2_0 = "version=\"2.0\"";
        VERSION_2_1 = "version=\"2.1\"";
        XMLNS_2_0 = "\"http://java.sun.com/xml/ns/j2ee\"";
        XMLNS_2_1 = "\"http://java.sun.com/xml/ns/javaee\"";
    }

    public String getEntityName(EntityRecognizerContext context) {
        String body = context.getBody();
        if (body == null || !"tld".equals(context.getExtension())) {
            return null;
        }
        XMLRecognizerContext xml = context.getXMLContext();
        if (xml.isDTD()) {
            String publicId = xml.getPublicId();
            String systemId = xml.getSystemId();
            String root = xml.getRootName();
            if (!"taglib".equals(root)) {
                return null;
            }
            if ("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN".equals(publicId)) {
                return "FileTLD_PRO";
            }
            if ("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN".equals(publicId)) {
                return "FileTLD_1_2";
            }
            if (systemId != null && systemId.indexOf("web-jsptaglibrary_1_1.dtd") >= 0) {
                return "FileTLD_PRO";
            }
            if (systemId != null && systemId.indexOf("web-jsptaglibrary_1_2.dtd") >= 0) {
                return "FileTLD_1_2";
            }
            return null;
        }
        return body.indexOf("<taglib") >= 0 && body.indexOf(VERSION_2_0) > 0 && body.indexOf("xmlns=" + XMLNS_2_0) > 0 ? "FileTLD_2_0" : (this.isTLD20WithNamespace(body, VERSION_2_0, XMLNS_2_0) ? "FileTLD_2_0" : (body.indexOf("<taglib") >= 0 && body.indexOf(VERSION_2_1) > 0 && body.indexOf("xmlns=" + XMLNS_2_1) > 0 ? "FileTLD_2_1" : (this.isTLD20WithNamespace(body, VERSION_2_1, XMLNS_2_1) ? "FileTLD_2_1" : "FileTLD")));
    }

    private boolean isTLD20WithNamespace(String body, String version, String xmlns) {
        if (body.indexOf(version) < 0) {
            return false;
        }
        int q = body.indexOf(xmlns);
        if (q < 0) {
            return false;
        }
        String s = body.substring(0, q);
        int b = s.lastIndexOf(60);
        if (b < 0) {
            return false;
        }
        int ti = s.indexOf(":taglib", b);
        if (ti < 0) {
            return false;
        }
        String namespace = s.substring(b + 1, ti);
        int e = s.lastIndexOf("xmlns:" + namespace);
        return e >= 0;
    }
}

