/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.log.LogHelper;
import org.jboss.tools.common.meta.constraint.impl.XAttributeConstraintQClassName;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.ValidationErrorManager;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.validation.Check;
import org.jboss.tools.jst.web.validation.WebXMLCoreValidator;
import org.jboss.tools.jst.web.validation.WebXMLValidatorMessages;

public class CheckClass
extends Check {
    XAttributeConstraintQClassName constraint = new XAttributeConstraintQClassName();
    boolean allowsPrimitive = false;
    String implementsType = null;
    String extendsType = null;
    String visualAttr;

    public CheckClass(ValidationErrorManager manager, String preference, String attr) {
        super(manager, preference, attr);
        this.visualAttr = attr;
    }

    protected String getShortId() {
        return WebXMLCoreValidator.SHORT_ID;
    }

    public CheckClass(ValidationErrorManager manager, String preference, String attr, boolean allowsPrimitive, String implementsType, String extendsType) {
        this(manager, preference, attr);
        this.allowsPrimitive = allowsPrimitive;
        this.implementsType = implementsType;
        this.extendsType = extendsType;
    }

    public CheckClass setVisualAttribute(String v) {
        this.visualAttr = v;
        return this;
    }

    @Override
    public void check(XModelObject object) {
        IProjectValidationContext context;
        if (this.attr == null) {
            return;
        }
        String value = object.getAttributeValue(this.attr);
        if (value == null) {
            return;
        }
        if (value.length() == 0 || this.isJavaLang(value)) {
            return;
        }
        if (this.isPrimitive(value)) {
            if (!this.allowsPrimitive) {
                this.fireNotExist(object, this.preference, value);
            }
            return;
        }
        if (!this.checkQualifiedName(value)) {
            this.fireInvalid(object, this.attr, value);
            return;
        }
        IType type = CheckClass.getValidType(value, object);
        IFile f = (IFile)object.getAdapter(IFile.class);
        if (f != null && (context = this.manager.getValidationContext()) != null) {
            context.addLinkedCoreResource(this.getShortId(), value, f.getFullPath(), true);
            if (type != null && type.getResource() != null && type.exists()) {
                context.addLinkedCoreResource(this.getShortId(), type.getResource().getFullPath().toOSString(), f.getFullPath(), true);
            }
        }
        if (type != null) {
            try {
                this.check(object, value, type);
            }
            catch (Exception e) {
                LogHelper.logError((String)"org.jboss.tools.jst.web.verification", (Throwable)e);
            }
            return;
        }
        this.fireNotExist(object, this.preference, value);
    }

    protected void check(XModelObject object, String value, IType type) throws JavaModelException {
        String mustExtend;
        String mustImpl = this.checkImplements(object, type);
        if (mustImpl != null) {
            this.fireImplements(object, this.preference, value, mustImpl);
        }
        if ((mustExtend = this.checkExtends(object, type)) != null) {
            this.fireExtends(object, this.preference, value, mustExtend);
        }
    }

    private boolean checkQualifiedName(String value) {
        return this.constraint.accepts(value);
    }

    protected String checkImplements(XModelObject object, IType type) throws JavaModelException {
        if ("java.lang.Class".equals(type.getFullyQualifiedName())) {
            return null;
        }
        String impl = this.implementsType;
        if (impl == null || impl.length() == 0) {
            return null;
        }
        String[] is = type.getSuperInterfaceNames();
        int i = 0;
        while (i < is.length) {
            String f = EclipseJavaUtil.resolveType((IType)type, (String)is[i]);
            if (f != null && f.equals(impl)) {
                return null;
            }
            ++i;
        }
        if (type.isInterface()) {
            return impl;
        }
        String f = type.getSuperclassName();
        if (f == null || f.length() == 0 || "java.lang.Object".equals(f)) {
            return impl;
        }
        if ((f = EclipseJavaUtil.resolveType((IType)type, (String)f)) == null || f.length() == 0 || "java.lang.Object".equals(f)) {
            return impl;
        }
        type = CheckClass.getValidType(f, object);
        if (type == null) {
            return impl;
        }
        return this.checkImplements(object, type);
    }

    protected String checkExtends(XModelObject object, IType type) throws JavaModelException {
        if (type.isInterface()) {
            return null;
        }
        if ("java.lang.Class".equals(type.getFullyQualifiedName())) {
            return null;
        }
        String ext = this.extendsType;
        if (ext == null || ext.length() == 0 || ext.equals(type.getFullyQualifiedName())) {
            return null;
        }
        String f = type.getSuperclassName();
        if (f == null || f.length() == 0 || "java.lang.Object".equals(f)) {
            return ext;
        }
        if (f.equals(ext)) {
            return null;
        }
        if ((f = EclipseJavaUtil.resolveType((IType)type, (String)f)) == null || f.length() == 0 || "java.lang.Object".equals(f)) {
            return ext;
        }
        if (f.equals(ext)) {
            return null;
        }
        type = CheckClass.getValidType(f, object);
        if (type == null) {
            return ext;
        }
        return this.checkExtends(object, type);
    }

    private boolean isPrimitive(String value) {
        return ".int.boolean.char.byte.double.float.long.short.".indexOf("." + value + ".") >= 0;
    }

    private boolean isJavaLang(String value) {
        if (value.indexOf(46) < 0) {
            return ".String.Integer.Boolean.Character.Byte.Double.Float.Long.Short.".indexOf("." + value + ".") >= 0;
        }
        if (value.startsWith("java.lang.")) {
            return this.isJavaLang(value.substring(10));
        }
        return false;
    }

    protected void fireImplements(XModelObject object, String id, String value, String interfaceName) {
        this.fireMessage(object, WebXMLValidatorMessages.CLASS_NOT_IMPLEMENTS, this.visualAttr, value, interfaceName);
    }

    protected void fireExtends(XModelObject object, String id, String value, String superName) {
        this.fireMessage(object, WebXMLValidatorMessages.CLASS_NOT_EXTENDS, this.visualAttr, value, superName);
    }

    protected void fireInvalid(XModelObject object, String id, String value) {
        this.fireMessage(object, WebXMLValidatorMessages.CLASS_NOT_VALID, this.visualAttr, value);
    }

    protected void fireNotExist(XModelObject object, String id, String value) {
        this.fireMessage(object, WebXMLValidatorMessages.CLASS_NOT_EXISTS, this.visualAttr, value);
    }

    public static IType getValidType(String className, XModelObject o) {
        IProject project = EclipseResourceUtil.getProject((XModelObject)o);
        if (project == null) {
            return null;
        }
        IType type = EclipseResourceUtil.getValidType((IProject)project, (String)className);
        if (type != null) {
            return type;
        }
        IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)project);
        if (javaProject != null) {
            try {
                type = EclipseJavaUtil.findType((IJavaProject)javaProject, (String)className);
            }
            catch (JavaModelException e) {
                WebModelPlugin.getDefault().logError(e);
            }
            if (type != null) {
                return type;
            }
        }
        if (EclipseResourceUtil.isContainedInOutput((IProject)project, (String)className)) {
            return EclipseResourceUtil.getValidType((IProject)project, (String)"java.lang.Class");
        }
        return null;
    }
}

