/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.livereload.core.internal.util.Logger;
import org.jboss.tools.livereload.core.internal.util.WSTUtils;
import org.jboss.tools.usage.event.UsageEvent;
import org.jboss.tools.usage.event.UsageEventType;
import org.jboss.tools.usage.event.UsageReporter;
import org.osgi.framework.BundleContext;

public class JBossLiveReloadCoreActivator
extends Plugin {
    public static final String PLUGIN_ID = "org.jboss.tools.livereload.core";
    private static JBossLiveReloadCoreActivator plugin;
    private final UsageEventType liveReloadServerCreationEventType = new UsageEventType((Plugin)this, "serverCreated", "Number of LiveReload server creations", UsageEventType.HOW_MANY_TIMES_VALUE_DESCRIPTION);
    private final UsageEventType liveReloadServerStartEventType = new UsageEventType((Plugin)this, "serverStarted", "Number of LiveReload server starts", UsageEventType.HOW_MANY_TIMES_VALUE_DESCRIPTION);
    private final UsageEventType liveReloadMessageSentToClientEventType = new UsageEventType((Plugin)this, "reloadCommandSent", "Number of 'reload' command sent to the browsers", UsageEventType.HOW_MANY_TIMES_VALUE_DESCRIPTION);

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        UsageReporter.getInstance().registerEvent(this.liveReloadServerCreationEventType);
        UsageReporter.getInstance().registerEvent(this.liveReloadServerStartEventType);
        UsageReporter.getInstance().registerEvent(this.liveReloadMessageSentToClientEventType);
    }

    public void stop(BundleContext context) throws Exception {
        for (IServer liveReloadServer : WSTUtils.findLiveReloadServers()) {
            try {
                WSTUtils.stop(liveReloadServer, 10L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                Logger.error("Failed to stop '" + liveReloadServer.getName() + "' within expected duration.", e);
            }
            catch (RuntimeException e) {
                Logger.error("Failed to stop '" + liveReloadServer.getName() + "'", e);
            }
        }
        plugin = null;
        super.stop(context);
    }

    public static JBossLiveReloadCoreActivator getDefault() {
        return plugin;
    }

    public InputStream getResourceContent(String path) throws IOException {
        URL resource = this.getBundle().getResource(path);
        if (resource == null) {
            return null;
        }
        return resource.openStream();
    }

    public void countLiveReloadServerCreation() {
        UsageEvent liveReloadServerCreationEvent = this.liveReloadServerCreationEventType.event();
        UsageReporter.getInstance().countEvent(liveReloadServerCreationEvent);
    }

    public void countLiveReloadServerStart() {
        UsageEvent liveReloadServerStartEvent = this.liveReloadServerStartEventType.event();
        UsageReporter.getInstance().countEvent(liveReloadServerStartEvent);
    }

    public void countLiveReloadMessageSentToClient() {
        UsageEvent liveReloadMessageSentToClientEvent = this.liveReloadMessageSentToClientEventType.event();
        UsageReporter.getInstance().countEvent(liveReloadMessageSentToClientEvent);
    }
}

