/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.server.jetty;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.proxy.AsyncMiddleManServlet;
import org.jboss.tools.livereload.core.internal.util.HttpUtils;
import org.jboss.tools.livereload.core.internal.util.Logger;
import org.jboss.tools.livereload.core.internal.util.ScriptInjectionUtils;
import org.jboss.tools.livereload.core.internal.util.URIUtils;

public class LiveReloadScriptInjectionMiddleManServlet
extends AsyncMiddleManServlet {
    private static final long serialVersionUID = -5338002334208801491L;
    private final String scriptContent;
    private final String proxyHost;
    private final int proxyPort;
    private final String proxyBasePath;
    private final int targetPort;
    private final String targetHost;
    private final String targetBasePath;
    private final boolean enableScriptInjection;

    public LiveReloadScriptInjectionMiddleManServlet(String proxyHost, int proxyPort, String proxyBasePath, String targetHost, int targetPort, String targetBasePath, int livereloadPort, boolean enableScriptInjection) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyBasePath = proxyBasePath;
        this.targetHost = targetHost;
        this.targetPort = targetPort;
        this.targetBasePath = targetBasePath.endsWith("/") ? targetBasePath : String.valueOf(targetBasePath) + "/";
        this.enableScriptInjection = enableScriptInjection;
        this.scriptContent = "<script>document.write('<script src=\"http://' + location.host.split(':')[0]+ ':" + livereloadPort + "/livereload.js\"></'+ 'script>')</script>";
    }

    protected AsyncMiddleManServlet.ContentTransformer newServerResponseContentTransformer(HttpServletRequest clientRequest, HttpServletResponse proxyResponse, Response serverResponse) {
        String contentType = proxyResponse.getContentType();
        if (this.enableScriptInjection && HttpStatus.isSuccess((int)serverResponse.getStatus()) && !"/livereload".equals(clientRequest.getRequestURI()) && HttpUtils.isHtmlContentType(contentType)) {
            return new ScriptInjectionContentTransformer(serverResponse);
        }
        return super.newServerResponseContentTransformer(clientRequest, proxyResponse, serverResponse);
    }

    protected String rewriteTarget(HttpServletRequest request) {
        try {
            URI requestURI = new URI(request.getRequestURI());
            String userInfo = requestURI.getUserInfo();
            String targetPath = String.valueOf(this.targetBasePath) + requestURI.getPath().substring(this.proxyBasePath.length());
            URI rewrittenURI = new URI(request.getScheme(), userInfo, this.targetHost, this.targetPort, targetPath, request.getQueryString(), requestURI.getFragment());
            return rewrittenURI.toString();
        }
        catch (URISyntaxException e) {
            Logger.error("Failed to parse the requested URI", e);
            return null;
        }
    }

    public String filterServerResponseHeader(HttpServletRequest request, Response serverResponse, String headerName, String headerValue) {
        if ("Location".equals(headerName)) {
            try {
                return URIUtils.convert(headerValue).toHost(this.proxyHost).toPort(this.proxyPort);
            }
            catch (URISyntaxException e) {
                Logger.error("Failed to rewrite the 'Location' response header value '" + headerValue + "'", e);
            }
        }
        return super.filterServerResponseHeader(request, serverResponse, headerName, headerValue);
    }

    private final class ScriptInjectionContentTransformer
    implements AsyncMiddleManServlet.ContentTransformer {
        private final ByteBuffer buffer;
        private final Response serverResponse;

        public ScriptInjectionContentTransformer(Response serverResponse) {
            this.serverResponse = serverResponse;
            int contentLength = Integer.parseInt(serverResponse.getHeaders().get("Content-Length"));
            this.buffer = ByteBuffer.allocate(contentLength);
        }

        public void transform(ByteBuffer input, boolean finished, List<ByteBuffer> output) throws IOException {
            this.buffer.put(input);
            if (finished) {
                Logger.debug("Writing response...");
                String returnedContentType = this.serverResponse.getHeaders().get("Content-Type");
                Charset charset = HttpUtils.getContentCharSet(returnedContentType, "UTF-8");
                byte[] bytes = new byte[this.buffer.limit()];
                this.buffer.rewind();
                this.buffer.get(bytes);
                ByteArrayInputStream serverResponseBody = new ByteArrayInputStream(bytes);
                char[] modifiedResponseContent = ScriptInjectionUtils.injectContent(serverResponseBody, LiveReloadScriptInjectionMiddleManServlet.this.scriptContent);
                CharBuffer modifiedResponse = CharBuffer.wrap(modifiedResponseContent);
                output.add(charset.encode(modifiedResponse));
            }
        }
    }
}

