/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.server.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.livereload.core.internal.util.HttpUtils;
import org.jboss.tools.livereload.core.internal.util.Logger;
import org.jboss.tools.livereload.core.internal.util.ResourceUtils;

public class WorkspaceFileServlet
extends HttpServlet {
    private static final long serialVersionUID = 163695311668462503L;
    public static final String BASE_PATH = "basePath";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpServletResponse httpServletResponse = response;
        String requestURI = request.getRequestURI();
        Logger.info("Serving " + requestURI);
        if (requestURI == null) {
            httpServletResponse.setStatus(400);
        } else {
            String resourceURI;
            IResource resource;
            String baseURI = this.getInitParameter(BASE_PATH);
            if (baseURI != null && !requestURI.startsWith(baseURI)) {
                Logger.debug("Unknown location: {} (invalid base path)", requestURI);
                httpServletResponse.setStatus(404);
            }
            if ((resource = ResourceUtils.retrieveResource(resourceURI = baseURI != null ? requestURI.substring(baseURI.length()) : requestURI)) != null && resource.getType() == 1) {
                try {
                    IFile workspaceFile = (IFile)resource;
                    byte[] scriptContent = IOUtils.toByteArray((InputStream)workspaceFile.getContents());
                    httpServletResponse.getOutputStream().write(scriptContent);
                    httpServletResponse.setStatus(200);
                    Charset charset = HttpUtils.getContentCharSet(request.getHeader("Accept"), workspaceFile.getCharset());
                    String guessedContentType = URLConnection.guessContentTypeFromName(resource.getName());
                    if (guessedContentType != null && !guessedContentType.contains("charset")) {
                        guessedContentType = guessedContentType.concat("; charset=").concat(charset.name());
                    }
                    httpServletResponse.setContentType(guessedContentType);
                }
                catch (CoreException e) {
                    Logger.error("Error occurred while returning content at location: " + requestURI, e);
                    httpServletResponse.setStatus(500);
                }
            } else if (resource != null && resource.getType() == 2) {
                Logger.debug("Forbidden location: {} is a folder", requestURI);
                httpServletResponse.setStatus(403);
            } else {
                Logger.debug("Unknown location: {} ", requestURI);
                httpServletResponse.setStatus(404);
            }
        }
    }
}

