/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.jboss.tools.livereload.core.internal.service.EventService;
import org.jboss.tools.livereload.core.internal.service.LiveReloadClientRefreshedEvent;
import org.jboss.tools.livereload.core.internal.service.LiveReloadClientRefreshingEvent;
import org.jboss.tools.livereload.core.internal.service.ServerResourcePublishedEvent;
import org.jboss.tools.livereload.core.internal.service.ServerStartedEvent;
import org.jboss.tools.livereload.core.internal.service.ServerStoppedEvent;
import org.jboss.tools.livereload.core.internal.util.Logger;

public class ServerLifeCycleListener
implements IServerListener,
IServerLifecycleListener,
IPublishListener {
    public static final int SERVER_LISTENER = 1;
    public static final int PUBLISH_LISTENER = 2;
    private final Map<IServer, Integer> supervisedServers = new HashMap<IServer, Integer>();
    private final IServer liveReloadServer;

    public ServerLifeCycleListener(IServer liveReloadServer) {
        this.liveReloadServer = liveReloadServer;
        this.start();
    }

    private void start() {
        IServer[] iServerArray = ServerCore.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (server.getServerType() != null && !"org.jboss.tools.livereload.serverType".equals(server.getServerType().getId())) {
                Logger.info("Adding ServerListener to existing server: " + server.getName());
                this.addServerListener(server);
                if (server.getServerState() == 2) {
                    Logger.info("Also adding PublishListener to existing server: " + server.getName());
                    this.addPublishListener(server);
                }
            }
            ++n2;
        }
    }

    public void stop() {
        IServer[] iServerArray = ServerCore.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (server.getServerType() != null && !"org.jboss.tools.livereload.serverType".equals(server.getServerType().getId())) {
                Logger.info("Removing ServerListener to existing server: " + server.getName());
                this.removeServerListener(server);
                if (server.getServerState() == 2) {
                    Logger.info("Also removing PublishListener to existing server: " + server.getName());
                    this.removePublishListener(server);
                }
            }
            ++n2;
        }
    }

    public void serverAdded(IServer server) {
        Logger.info("New Server Listener added for new server:" + server.getName());
        this.addServerListener(server);
    }

    public void serverRemoved(IServer server) {
        Logger.info("Server Listener removed for server:" + server.getName());
        this.removeServerListener(server);
    }

    public void serverChanged(IServer server) {
    }

    public void serverChanged(ServerEvent event) {
        IServer server = event.getServer();
        if (event.getKind() == 17 && server.getServerState() == 2) {
            Logger.debug("Server {} started", server.getName());
            this.addPublishListener(server);
            EventService.getInstance().publish(new ServerStartedEvent(server));
        } else if (event.getKind() == 17 && server.getServerState() == 4) {
            Logger.debug("Server {} stopped", server.getName());
            this.removePublishListener(server);
            EventService.getInstance().publish(new ServerStoppedEvent(server));
        }
    }

    public void publishStarted(IServer server) {
        EventService.getInstance().publish(new LiveReloadClientRefreshingEvent(server.getId()));
    }

    public void publishFinished(IServer server, IStatus status) {
        EventService.getInstance().publish(new LiveReloadClientRefreshedEvent(server.getId()));
        Logger.trace("Received notification after publish on server '{}' (started={}) finished with status {}", server.getName(), server.getServerState() == 2, status.getSeverity());
        if (server.getServerState() == 2 && status.isOK()) {
            this.waitBeforeNotifying();
            EventService.getInstance().publish(new ServerResourcePublishedEvent(server));
        } else {
            Logger.debug("Ignoring this publish notification..");
        }
    }

    private void waitBeforeNotifying() {
        final int notificationDelay = this.liveReloadServer.getAttribute("org.jboss.tools.livereload.core.notification_delay", 0);
        if (notificationDelay > 0) {
            Job waitJob = new Job("Waiting before notifying clients..."){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        int i = 0;
                        while (i < notificationDelay) {
                            Thread.sleep(1000L);
                            if (monitor.isCanceled()) {
                                this.cancel();
                                return Status.CANCEL_STATUS;
                            }
                            ++i;
                        }
                    }
                    catch (InterruptedException e) {
                        Logger.error("Failed to wait to " + notificationDelay + " seconds before notifying the clients", e);
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            waitJob.schedule();
            try {
                waitJob.join();
            }
            catch (InterruptedException e) {
                Logger.error("Failed to wait to " + notificationDelay + " seconds before notifying the clients", e);
            }
        }
    }

    private void addServerListener(IServer server) {
        server.addServerListener((IServerListener)this);
        this.addFlag(server, 1);
        if (server.getServerState() == 2) {
            EventService.getInstance().publish(new ServerStartedEvent(server));
        }
    }

    private void addPublishListener(IServer server) {
        server.addPublishListener((IPublishListener)this);
        this.addFlag(server, 2);
    }

    private void removeServerListener(IServer server) {
        server.removeServerListener((IServerListener)this);
        this.removeFlag(server, 1);
        EventService.getInstance().publish(new ServerStoppedEvent(server));
    }

    private void removePublishListener(IServer server) {
        server.removePublishListener((IPublishListener)this);
        this.removeFlag(server, 2);
    }

    private void addFlag(IServer server, int flag) {
        if (this.supervisedServers.containsKey(server)) {
            int value = this.supervisedServers.get(server);
            if ((value & flag) == 0) {
                this.supervisedServers.put(server, value += flag);
            }
        } else {
            this.supervisedServers.put(server, flag);
        }
    }

    private void removeFlag(IServer server, int flag) {
        int value;
        if (this.supervisedServers.containsKey(server) && ((value = this.supervisedServers.get(server).intValue()) & flag) > 0) {
            this.supervisedServers.put(server, value -= flag);
        }
    }

    public List<IServer> getSupervisedServers(int state) {
        ArrayList<IServer> servers = new ArrayList<IServer>();
        for (Map.Entry<IServer, Integer> entry : this.supervisedServers.entrySet()) {
            int value = entry.getValue();
            if ((value & state) <= 0) continue;
            servers.add(entry.getKey());
        }
        return servers;
    }
}

