/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.service;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.jboss.tools.livereload.core.internal.service.EventFilter;
import org.jboss.tools.livereload.core.internal.service.WorkspaceResourceChangedEvent;

public class WorkspaceResourceChangedEventFilter
implements EventFilter {
    static final List<String> acceptedFileTypes = Arrays.asList("html", "xhtml", "htm", "css", "js", "gif", "png", "jpg", "jpeg", "bmp", "ico", "adoc", "asciidoc");
    private final IProject project;

    public WorkspaceResourceChangedEventFilter(IProject project) {
        this.project = project;
    }

    @Override
    public boolean accept(EventObject e) {
        if (e instanceof WorkspaceResourceChangedEvent) {
            WorkspaceResourceChangedEvent event = (WorkspaceResourceChangedEvent)e;
            for (IResource resource : event.getChangedResources()) {
                String fileExtension;
                String string = fileExtension = resource.getFileExtension() != null ? resource.getFileExtension().toLowerCase() : null;
                if (!resource.getProject().equals((Object)this.project) || fileExtension == null || !acceptedFileTypes.contains(fileExtension)) continue;
                return true;
            }
        }
        return false;
    }
}

