/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.util;

public class PathBuilder {
    private final StringBuilder path = new StringBuilder();

    public static PathBuilder from(String pathFragment) {
        PathBuilder pathBuilder = new PathBuilder();
        return pathBuilder.path(pathFragment);
    }

    public PathBuilder path(String pathFragment) {
        if (pathFragment == null) {
            return this;
        }
        if (!pathFragment.startsWith("/")) {
            if (!this.currentPathEndsWith('/')) {
                this.path.append("/").append(pathFragment);
            } else if (this.currentPathEndsWith('/')) {
                this.path.append(pathFragment);
            }
        } else if (!this.currentPathEndsWith('/')) {
            this.path.append(pathFragment);
        } else if (this.currentPathEndsWith('/') && pathFragment.length() > 1) {
            this.path.append(pathFragment.substring(1));
        } else if (this.path.toString().length() == 0) {
            this.path.append(pathFragment);
        }
        return this;
    }

    private boolean currentPathEndsWith(char lastChar) {
        return this.path.length() > 0 && this.path.charAt(this.path.length() - 1) == lastChar;
    }

    public String build() {
        return this.path.toString();
    }
}

