/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;

public class ReloadCommandGenerator {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static String generateReloadCommand(String location) throws IOException, URISyntaxException {
        return ReloadCommandGenerator.buildRefreshCommand(location, false);
    }

    public static List<String> generateReloadCommands(List<IResource> files) throws IOException, URISyntaxException {
        Map<String, List<IResource>> dispatchedFiles = ReloadCommandGenerator.dispatch(files);
        ArrayList<String> commands = new ArrayList<String>();
        if (dispatchedFiles.containsKey("html")) {
            for (IResource file : dispatchedFiles.get("html")) {
                commands.add(ReloadCommandGenerator.buildRefreshCommand(file.getLocation().toOSString(), true));
            }
            return commands;
        }
        for (Map.Entry<String, List<IResource>> entry : dispatchedFiles.entrySet()) {
            for (IResource file : entry.getValue()) {
                commands.add(ReloadCommandGenerator.buildRefreshCommand(file.getLocation().toOSString(), true));
            }
        }
        return commands;
    }

    private static Map<String, List<IResource>> dispatch(List<IResource> files) {
        LinkedHashMap<String, List<IResource>> dispatchedFiles = new LinkedHashMap<String, List<IResource>>();
        for (IResource file : files) {
            String fileExtension;
            String string = fileExtension = file.getFileExtension() != null ? file.getFileExtension().toLowerCase() : null;
            if (fileExtension == null) continue;
            if (dispatchedFiles.containsKey(fileExtension)) {
                ((List)dispatchedFiles.get(fileExtension)).add(file);
                continue;
            }
            dispatchedFiles.put(fileExtension, new ArrayList<IResource>(Arrays.asList(file)));
        }
        return dispatchedFiles;
    }

    private static String buildRefreshCommand(String location, boolean liveCSS) throws IOException, URISyntaxException {
        LinkedHashMap<String, Object> reloadArgs = new LinkedHashMap<String, Object>();
        reloadArgs.put("command", "reload");
        reloadArgs.put("path", location);
        reloadArgs.put("liveCSS", liveCSS);
        StringWriter commandWriter = new StringWriter();
        objectMapper.writeValue((Writer)commandWriter, reloadArgs);
        return commandWriter.toString();
    }
}

