/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.apt.internal.processor;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecution;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.jboss.tools.maven.apt.internal.AnnotationProcessorConfiguration;
import org.jboss.tools.maven.apt.internal.DefaultAnnotationProcessorConfiguration;
import org.jboss.tools.maven.apt.internal.processor.MavenProcessorBuildParticipant;
import org.jboss.tools.maven.apt.internal.processor.MavenProcessorJdtAptDelegate;
import org.jboss.tools.maven.apt.internal.utils.ProjectUtils;

public class MavenProcessorExecutionDelegate
extends MavenProcessorJdtAptDelegate {
    private static final String GOAL_PROCESS_TEST = "process-test";

    @Override
    protected AnnotationProcessorConfiguration getAnnotationProcessorConfiguration(IProgressMonitor monitor) throws CoreException {
        MojoExecution testMojoExecution;
        AnnotationProcessorConfiguration configuration = super.getAnnotationProcessorConfiguration(monitor);
        if (configuration instanceof DefaultAnnotationProcessorConfiguration && (testMojoExecution = this.getProcessorPluginMojoExecution(this.mavenFacade, GOAL_PROCESS_TEST, monitor)) != null) {
            File generatedTestOutputDirectory = this.getParameterValue("outputDirectory", File.class, this.mavenSession, testMojoExecution);
            ((DefaultAnnotationProcessorConfiguration)configuration).setTestOutputDirectory(generatedTestOutputDirectory);
        }
        return configuration;
    }

    @Override
    public void configureProject(IProgressMonitor monitor) throws CoreException {
        boolean isAnnotationProcessingEnabled;
        AnnotationProcessorConfiguration configuration;
        File generatedSourcesDirectory;
        IProject eclipseProject = this.mavenFacade.getProject();
        ProjectUtils.disableApt(eclipseProject);
        if (!eclipseProject.hasNature("org.eclipse.jdt.core.javanature")) {
            AbstractProjectConfigurator.addNature((IProject)eclipseProject, (String)"org.eclipse.jdt.core.javanature", (IProgressMonitor)monitor);
        }
        if ((generatedSourcesDirectory = (configuration = this.getAnnotationProcessorConfiguration(monitor)).getOutputDirectory()) == null) {
            return;
        }
        LinkedHashSet<File> resolvedJarArtifacts = new LinkedHashSet<File>(configuration.getDependencies());
        if (configuration.isAddProjectDependencies()) {
            List<Artifact> artifacts = ProjectUtils.getProjectArtifacts(this.mavenFacade);
            resolvedJarArtifacts.addAll(ProjectUtils.filterToResolvedJars(artifacts));
        }
        boolean bl = isAnnotationProcessingEnabled = configuration.isAnnotationProcessingEnabled() && ProjectUtils.containsAptProcessors(resolvedJarArtifacts);
        if (isAnnotationProcessingEnabled) {
            File generatedTestSourcesDirectory;
            if (!generatedSourcesDirectory.exists()) {
                generatedSourcesDirectory.mkdirs();
            }
            if ((generatedTestSourcesDirectory = configuration.getTestOutputDirectory()) != null && !generatedTestSourcesDirectory.exists()) {
                generatedTestSourcesDirectory.mkdirs();
            }
        }
    }

    @Override
    public AbstractBuildParticipant getMojoExecutionBuildParticipant(MojoExecution execution) {
        return new MavenProcessorBuildParticipant(execution);
    }
}

