/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.cdi.configurators;

import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.maven.cdi.MavenCDIActivator;
import org.jboss.tools.maven.cdi.internal.BeansXmlQuickPeek;
import org.jboss.tools.maven.core.ProjectUtil;
import org.jboss.tools.maven.core.VersionUtil;
import org.jboss.tools.maven.core.internal.project.facet.MavenFacetInstallDataModelProvider;
import org.jboss.tools.maven.ui.Activator;

public class CDIProjectConfigurator
extends AbstractProjectConfigurator {
    private static final String CDI_API_GROUP_ID = "javax.enterprise";
    private static final String CDI_API_ARTIFACT_ID = "cdi-api";
    protected static final IProjectFacet dynamicWebFacet = ProjectFacetsManager.getProjectFacet((String)"jst.web");
    protected static final IProjectFacet ejbFacet;
    protected static final IProjectFacetVersion dynamicWebVersion;
    protected static final IProjectFacetVersion ejbVersion;
    protected static final IProjectFacet cdiFacet;
    protected static final IProjectFacet m2Facet;
    protected static final IProjectFacetVersion m2Version;
    private static final String DEFAULT_CDI_VERSION;

    static {
        dynamicWebVersion = dynamicWebFacet.getVersion("2.5");
        ejbFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
        ejbVersion = ejbFacet.getVersion("3.0");
        cdiFacet = ProjectFacetsManager.getProjectFacet((String)"jst.cdi");
        DEFAULT_CDI_VERSION = "1.0";
        m2Facet = ProjectFacetsManager.getProjectFacet((String)"jboss.m2");
        m2Version = m2Facet.getVersion("1.0");
    }

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = request.getMavenProject();
        IProject project = request.getProject();
        this.configureInternal(mavenProject, project, monitor);
    }

    private void configureInternal(MavenProject mavenProject, IProject project, IProgressMonitor monitor) throws CoreException {
        boolean isJavaEEProject;
        if (!this.isCDIConfigurable(mavenProject)) {
            return;
        }
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
        String packaging = mavenProject.getPackaging();
        boolean bl = isJavaEEProject = "war".equals(packaging) || "ejb".equals(packaging);
        if (!isJavaEEProject && project.hasNature(CDICoreNature.NATURE_ID) || fproj != null && fproj.hasProjectFacet(cdiFacet) && fproj.hasProjectFacet(m2Facet)) {
            return;
        }
        String cdiVersion = this.getCDIVersion(project, mavenProject);
        if (cdiVersion != null) {
            if (fproj != null && isJavaEEProject) {
                this.installDefaultFacets(fproj, cdiVersion, monitor);
            }
            CDIUtil.enableCDI((IProject)project, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private boolean isCDIConfigurable(MavenProject mavenProject) {
        boolean configureCDI;
        String cdiActivation = mavenProject.getProperties().getProperty("m2e.cdi.activation");
        if (cdiActivation == null) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            configureCDI = store.getBoolean("configureCDI");
        } else {
            configureCDI = Boolean.valueOf(cdiActivation);
        }
        return configureCDI;
    }

    public void mavenProjectChanged(MavenProjectChangedEvent event, IProgressMonitor monitor) throws CoreException {
        IProject project;
        IMavenProjectFacade facade = event.getMavenProject();
        if (event.getFlags() == 1 && facade != null && this.isWTPProject(project = facade.getProject())) {
            MavenProject mavenProject = facade.getMavenProject(monitor);
            this.configureInternal(mavenProject, project, monitor);
        }
        super.mavenProjectChanged(event, monitor);
    }

    private boolean isWTPProject(IProject project) {
        return ModuleCoreNature.getModuleCoreNature((IProject)project) != null;
    }

    private void installM2Facet(IFacetedProject fproj, IProgressMonitor monitor) throws CoreException {
        if (!fproj.hasProjectFacet(m2Facet)) {
            IDataModel config = (IDataModel)new MavenFacetInstallDataModelProvider().create();
            config.setBooleanProperty("mavenProjectExists", true);
            fproj.installProjectFacet(m2Version, (Object)config, monitor);
        }
    }

    private void installDefaultFacets(IFacetedProject fproj, String cdiVersion, IProgressMonitor monitor) throws CoreException {
        IProjectFacetVersion currentWebVersion = fproj.getProjectFacetVersion(dynamicWebFacet);
        IProjectFacetVersion currentEjbVersion = fproj.getProjectFacetVersion(ejbFacet);
        if (currentWebVersion != null && currentWebVersion.compareTo((Object)dynamicWebVersion) > -1 || currentEjbVersion != null && currentEjbVersion.compareTo((Object)ejbVersion) > -1) {
            this.installCDIFacet(fproj, cdiVersion, monitor);
        }
        this.installM2Facet(fproj, monitor);
    }

    private void installCDIFacet(IFacetedProject fproj, String cdiVersionString, IProgressMonitor monitor) throws CoreException {
        IProjectFacetVersion facetVersion;
        if (!fproj.hasProjectFacet(cdiFacet) && (facetVersion = this.getCdiFacetVersion(cdiVersionString)) != null) {
            IDataModel model = MavenCDIActivator.getDefault().createCDIDataModel(fproj, facetVersion);
            fproj.installProjectFacet(facetVersion, (Object)model, monitor);
        }
    }

    private IProjectFacetVersion getCdiFacetVersion(String cdiVersionString) {
        IProjectFacetVersion facetVersion;
        String majorMinor = VersionUtil.getMajorMinorVersion((String)cdiVersionString);
        try {
            facetVersion = cdiFacet.getVersion(majorMinor);
        }
        catch (IllegalArgumentException iae) {
            facetVersion = cdiFacet.getDefaultVersion();
            MavenCDIActivator.log("CDI version " + majorMinor + " has no corresponding Facet, falling back to " + facetVersion.getVersionString());
        }
        return facetVersion;
    }

    private String getCDIVersion(IProject project, MavenProject mavenProject) throws CoreException {
        IFile beansXml;
        String version = Activator.getDefault().getDependencyVersion(mavenProject, CDI_API_GROUP_ID, CDI_API_ARTIFACT_ID);
        if (version == null) {
            version = this.inferCdiVersionFromDependencies(mavenProject);
        }
        if (version == null && (beansXml = this.getBeansXml(project)) != null) {
            try {
                BeansXmlQuickPeek quickPeek = new BeansXmlQuickPeek(beansXml);
                version = quickPeek.getVersion();
            }
            catch (Exception e) {
                MavenCDIActivator.log(e);
            }
            if (version == null) {
                version = DEFAULT_CDI_VERSION;
            }
        }
        return version;
    }

    private String inferCdiVersionFromDependencies(MavenProject mavenProject) {
        boolean hasCandidates = false;
        String cdiVersion = null;
        List repos = mavenProject.getRemoteArtifactRepositories();
        for (Artifact artifact : mavenProject.getArtifacts()) {
            if (!this.isKnownCdiExtension(artifact)) continue;
            hasCandidates = true;
            cdiVersion = Activator.getDefault().getDependencyVersion(artifact, repos, CDI_API_GROUP_ID, CDI_API_ARTIFACT_ID);
            if (cdiVersion != null) break;
        }
        if (hasCandidates && cdiVersion == null) {
            return DEFAULT_CDI_VERSION;
        }
        return cdiVersion;
    }

    private boolean isKnownCdiExtension(Artifact artifact) {
        return artifact.getGroupId().startsWith("org.jboss.seam.") && artifact.getVersion().startsWith("3.") || artifact.getGroupId().startsWith("org.apache.deltaspike.");
    }

    private IFile getBeansXml(IProject project) throws CoreException {
        IFile beansXml;
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        if (facetedProject != null && facetedProject.hasProjectFacet(dynamicWebFacet) && (beansXml = ProjectUtil.getWebResourceFile((IProject)project, (String)"WEB-INF/beans.xml")) != null && beansXml.exists()) {
            return beansXml;
        }
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            Set sources = EclipseResourceUtil.getSourceFolders((IProject)project);
            Path beansPath = new Path("META-INF/beans.xml");
            for (IFolder src : sources) {
                IFile beansXml2 = src.getFile((IPath)beansPath);
                if (beansXml2 == null || !beansXml2.exists()) continue;
                return beansXml2;
            }
        }
        return null;
    }
}

