/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.conversion.core;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.maven.conversion.core.DependencyCollector;
import org.jboss.tools.maven.conversion.core.internal.ComponentDependencyCollector;
import org.jboss.tools.maven.conversion.core.internal.JavaDependencyCollector;

public class DependencyCollectorFactory {
    public static final DependencyCollectorFactory INSTANCE = new DependencyCollectorFactory();
    Set<DependencyCollector> dependencyCollectors = new HashSet<DependencyCollector>();

    private DependencyCollectorFactory() {
        this.initDependencyCollectors();
    }

    private void initDependencyCollectors() {
        this.dependencyCollectors.clear();
        this.dependencyCollectors.add(new JavaDependencyCollector());
        this.dependencyCollectors.add(new ComponentDependencyCollector());
    }

    public DependencyCollector getDependencyCollector(IProject project) throws CoreException {
        for (DependencyCollector dc : this.dependencyCollectors) {
            if (!dc.appliesTo(project)) continue;
            return dc;
        }
        return null;
    }
}

