/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.conversion.ui.dialog;

import java.util.List;
import org.apache.maven.model.Dependency;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.ltk.ui.refactoring.resource.DeleteResourcesWizard;
import org.jboss.tools.maven.conversion.core.ProjectDependency;
import org.jboss.tools.maven.conversion.ui.dialog.IdentifyMavenDependencyPage;
import org.jboss.tools.maven.conversion.ui.internal.jobs.DeleteExistingClasspathEntriesJob;

public class ConvertToMavenDependencyWizard
extends Wizard {
    private IProject project;
    private List<ProjectDependency> entries;
    private IdentifyMavenDependencyPage identificationPage;
    private List<Dependency> dependencies;

    public ConvertToMavenDependencyWizard(IProject project, List<ProjectDependency> projectDependencies) {
        this.project = project;
        this.entries = projectDependencies;
        String title = "Convert to Maven ";
        title = this.entries.size() > 1 ? String.valueOf(title) + "Dependencies" : String.valueOf(title) + "Dependency";
        this.setWindowTitle(title);
    }

    public void addPages() {
        this.identificationPage = new IdentifyMavenDependencyPage(this.project, this.entries);
        this.addPage((IWizardPage)this.identificationPage);
    }

    public boolean performCancel() {
        this.identificationPage.cancel();
        return super.performCancel();
    }

    public boolean performFinish() {
        if (this.identificationPage != null) {
            this.dependencies = this.identificationPage.getDependencies();
            if (this.identificationPage.isDeleteJars()) {
                DeleteExistingClasspathEntriesJob deleteJob = new DeleteExistingClasspathEntriesJob(this.project);
                deleteJob.schedule();
                try {
                    deleteJob.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                IResource[] resourcesToDelete = this.identificationPage.getResourcesToDelete();
                if (resourcesToDelete != null && resourcesToDelete.length > 0) {
                    DeleteResourcesWizard wizard = new DeleteResourcesWizard(resourcesToDelete);
                    try {
                        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                        op.run(this.getShell(), "Delete project relative jars");
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        return true;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void dispose() {
        this.entries = null;
        this.project = null;
        super.dispose();
    }
}

