/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.conversion.ui.dialog;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.model.Dependency;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.ide.StringMatcher;
import org.jboss.tools.foundation.core.digest.DigestUtils;
import org.jboss.tools.maven.conversion.core.ProjectDependency;
import org.jboss.tools.maven.conversion.ui.dialog.xpl.ConversionUtils;
import org.jboss.tools.maven.conversion.ui.dialog.xpl.EditDependencyDialog;
import org.jboss.tools.maven.conversion.ui.internal.CellListener;
import org.jboss.tools.maven.conversion.ui.internal.MavenDependencyConversionActivator;
import org.jboss.tools.maven.conversion.ui.internal.jobs.DependencyResolutionJob;
import org.jboss.tools.maven.conversion.ui.internal.jobs.IdentificationJob;
import org.jboss.tools.maven.conversion.ui.internal.jobs.IdentifyJarJob;
import org.jboss.tools.maven.conversion.ui.internal.jobs.IdentifyProjectJob;
import org.jboss.tools.maven.core.identification.IFileIdentificationManager;
import org.jboss.tools.maven.core.internal.identification.FileIdentificationManager;
import org.jboss.tools.maven.ui.wizard.ConfigureMavenRepositoriesWizard;

public class IdentifyMavenDependencyPage
extends WizardPage {
    private static final String MULTIPLE_DEPENDENCIES_TEXT = "Multiple dependencies";
    private static final int DEPENDENCY_COLUMN = 2;
    private Map<ProjectDependency, Dependency> dependencyMap;
    private Map<ProjectDependency, Boolean> dependencyCheckStateMap;
    private Map<ProjectDependency, IdentificationJob> identificationJobs;
    private List<ProjectDependency> initialEntries;
    private Map<String, Boolean> dependencyResolution;
    private IProject project;
    private Image jarImage;
    private Image projectImage;
    private Image okImage;
    private Image failedImage;
    private Image loadingImage;
    private Image unresolvedImage;
    private CheckboxTableViewer dependenciesViewer;
    private Button deleteJarsBtn;
    private boolean deleteJars = true;
    private Button startIdentification;
    private Button stopButton;
    private Label warningImg;
    private Link warningLink;
    private IDialogSettings dialogSettings;
    private Text filterText;
    private static String MESSAGE = "Identify existing project references as Maven dependencies. Double-click on a Maven dependency to edit its details";

    public IdentifyMavenDependencyPage(IProject project, List<ProjectDependency> entries) {
        super("");
        this.project = project;
        this.initialEntries = Collections.unmodifiableList(entries);
        this.dependencyResolution = new ConcurrentHashMap<String, Boolean>();
        this.initDependencyMaps();
        this.initDialogSettings();
    }

    private void initDependencyMaps() {
        this.dependencyMap = new LinkedHashMap<ProjectDependency, Dependency>(this.initialEntries.size());
        this.dependencyCheckStateMap = new LinkedHashMap<ProjectDependency, Boolean>(this.initialEntries.size());
        for (ProjectDependency entry : this.initialEntries) {
            this.dependencyMap.put(entry, null);
            this.dependencyCheckStateMap.put(entry, Boolean.TRUE);
        }
    }

    private void initDialogSettings() {
        Object pluginSettings = MavenDependencyConversionActivator.getDefault() == null ? new DialogSettings("Workbench") : MavenDependencyConversionActivator.getDefault().getDialogSettings();
        this.dialogSettings = pluginSettings.getSection(this.getName());
        if (this.dialogSettings == null) {
            this.dialogSettings = pluginSettings.addNewSection(this.getName());
            pluginSettings.addSection(this.dialogSettings);
        }
    }

    public void dispose() {
        this.dialogSettings.put("isDeleteJars", this.isDeleteJars());
        if (this.jarImage != null) {
            this.jarImage.dispose();
        }
        if (this.okImage != null) {
            this.okImage.dispose();
        }
        if (this.projectImage != null) {
            this.projectImage.dispose();
        }
        if (this.failedImage != null) {
            this.failedImage.dispose();
        }
        if (this.loadingImage != null) {
            this.loadingImage.dispose();
        }
        if (this.unresolvedImage != null) {
            this.unresolvedImage.dispose();
        }
        for (IdentificationJob job : this.identificationJobs.values()) {
            if (job == null) continue;
            job.cancel();
        }
        this.dependencyMap = null;
        this.initialEntries = null;
        this.dependencyResolution = null;
    }

    private void initImages() {
        this.jarImage = MavenDependencyConversionActivator.getJarIcon();
        this.projectImage = MavenDependencyConversionActivator.getProjectIcon();
        this.okImage = MavenDependencyConversionActivator.getOkIcon();
        this.unresolvedImage = MavenDependencyConversionActivator.getWarningIcon();
        this.failedImage = MavenDependencyConversionActivator.getFailedIcon();
        this.loadingImage = MavenDependencyConversionActivator.getLoadingIcon();
    }

    private void createWarning(Composite container) {
        this.warningImg = new Label(container, 0x1000000);
        this.warningLink = new Link(container, 0);
        this.warningLink.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.warningImg);
        this.warningImg.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        this.warningLink.setText("Some selected dependencies can not be resolved. Click <a>here</a> to configure repositories in your settings.xml.");
        this.warningLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.openSettingsRepositoriesWizard();
            }

            private void openSettingsRepositoriesWizard() {
                ConfigureMavenRepositoriesWizard wizard = new ConfigureMavenRepositoriesWizard();
                WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                wizard.init(null, null);
                dialog.create();
                dialog.open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    public void createControl(Composite parent) {
        this.setTitle("Identify Maven dependencies");
        this.initImages();
        Composite container = new Composite(parent, 0);
        container.setEnabled(true);
        this.setControl((Control)container);
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 12;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.setMessage(MESSAGE);
        this.createWarning(container);
        this.displayDependenciesTable(container);
        Link remoteRepoPrefsLink = new Link(container, 0);
        remoteRepoPrefsLink.setText("Manage <a>remote repositories</a> used to identify dependencies.");
        GridData gd = new GridData(4, 4, true, true, 3, 1);
        remoteRepoPrefsLink.setLayoutData((Object)gd);
        remoteRepoPrefsLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IdentifyMavenDependencyPage.this.openRemoteRepoPrefs();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.deleteJars = this.dialogSettings.getBoolean("isDeleteJars");
        this.deleteJarsBtn = this.addCheckButton(container, "Delete original references from project", this.deleteJars);
        this.deleteJarsBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IdentifyMavenDependencyPage.this.deleteJars = IdentifyMavenDependencyPage.this.deleteJarsBtn.getSelection();
            }
        });
        this.runIdentificationJobs(null);
    }

    private Button addCheckButton(Composite container, String label, boolean selected) {
        Button checkBtn = new Button(container, 32);
        checkBtn.setText(label);
        checkBtn.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        checkBtn.setSelection(selected);
        return checkBtn;
    }

    private void openRemoteRepoPrefs() {
        String id = "org.jboss.tools.maven.ui.preferences.RemoteRepositoriesPreferencePage";
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, null).open();
    }

    private void displayDependenciesTable(Composite container) {
        this.filterText = new Text(container, 2432);
        this.filterText.setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).create());
        this.filterText.setMessage("Filter dependencies");
        this.filterText.setFocus();
        GridData gd = new GridData(4, 4, true, true, 2, 5);
        gd.heightHint = 500;
        gd.widthHint = 545;
        this.dependenciesViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)67586);
        Table table = this.dependenciesViewer.getTable();
        table.setFocus();
        table.setLayoutData((Object)gd);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn emptyColumn = new TableColumn(table, 0);
        emptyColumn.setWidth(20);
        TableViewerColumn sourceColumn = new TableViewerColumn((TableViewer)this.dependenciesViewer, 0);
        sourceColumn.getColumn().setText("Project Reference");
        sourceColumn.getColumn().setWidth(270);
        sourceColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ProjectDependency projectDependency = (ProjectDependency)element;
                return IdentifyMavenDependencyPage.this.getLabel(projectDependency);
            }

            public String getToolTipText(Object element) {
                ProjectDependency projectDependency = (ProjectDependency)element;
                if (projectDependency.getDependencyKind() != ProjectDependency.DependencyKind.Archive) {
                    return "";
                }
                try {
                    return "SHA1 Checksum : " + DigestUtils.sha1((File)ConversionUtils.getFile(projectDependency.getPath()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return "Unable to compute SHA1 Checksum";
                }
            }

            public Image getImage(Object element) {
                ProjectDependency projectDependency = (ProjectDependency)element;
                Image img = projectDependency.getDependencyKind() == ProjectDependency.DependencyKind.Archive ? IdentifyMavenDependencyPage.this.jarImage : IdentifyMavenDependencyPage.this.projectImage;
                return img;
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.dependenciesViewer, (int)2);
        TableViewerColumn dependencyColumn = new TableViewerColumn((TableViewer)this.dependenciesViewer, 0);
        dependencyColumn.getColumn().setText("Maven Dependency");
        dependencyColumn.getColumn().setWidth(270);
        dependencyColumn.setLabelProvider((CellLabelProvider)new DependencyLabelProvider());
        this.dependenciesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.dependenciesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IdentifyMavenDependencyPage.this.dependencyCheckStateMap.put((ProjectDependency)event.getElement(), event.getChecked());
                IdentifyMavenDependencyPage.this.refresh();
            }
        });
        ICheckStateProvider checkStateProvider = new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                Boolean checked = null;
                if (element instanceof ProjectDependency) {
                    checked = (Boolean)IdentifyMavenDependencyPage.this.dependencyCheckStateMap.get((ProjectDependency)element);
                }
                return checked != null && checked != false;
            }
        };
        this.dependenciesViewer.setCheckStateProvider(checkStateProvider);
        this.dependenciesViewer.setInput(this.dependencyMap.keySet());
        this.dependenciesViewer.setAllChecked(true);
        this.dependenciesViewer.getTable().addListener(8, (Listener)new CellListener(this.dependenciesViewer.getTable()){

            @Override
            protected void handle(int columnIndex, TableItem item) {
                if (columnIndex == 2) {
                    ProjectDependency projectDep = (ProjectDependency)item.getData();
                    IdentifyMavenDependencyPage.this.openDependencyDetails(projectDep);
                }
            }
        });
        final DependencyPatternFilter filter = new DependencyPatternFilter();
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (IdentifyMavenDependencyPage.this.filterText != null && !IdentifyMavenDependencyPage.this.filterText.isDisposed()) {
                    filter.setPattern(IdentifyMavenDependencyPage.this.filterText.getText());
                    IdentifyMavenDependencyPage.this.dependenciesViewer.refresh();
                }
            }
        });
        this.dependenciesViewer.addFilter((ViewerFilter)filter);
        this.addSelectionMenus();
        this.addSelectionButton(container, "Select All", true);
        this.addSelectionButton(container, "Deselect All", false);
        this.addEditButton(container, "Edit ...");
        this.addIdentifyButton(container, "Identify dependencies");
        this.addStopButton(container, "Stop identification");
    }

    private void addSelectionMenus() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (IdentifyMavenDependencyPage.this.dependenciesViewer.getSelection().isEmpty()) {
                    return;
                }
                if (IdentifyMavenDependencyPage.this.dependenciesViewer.getSelection() instanceof IStructuredSelection) {
                    final IStructuredSelection selection = (IStructuredSelection)IdentifyMavenDependencyPage.this.dependenciesViewer.getSelection();
                    boolean showSelect = false;
                    boolean showUnSelect = false;
                    Iterator iterator = selection.iterator();
                    while (iterator.hasNext()) {
                        if (IdentifyMavenDependencyPage.this.dependenciesViewer.getChecked(iterator.next())) {
                            showUnSelect = true;
                            continue;
                        }
                        showSelect = true;
                    }
                    if (showSelect) {
                        manager.add((IAction)new Action(){

                            public String getText() {
                                return "Select";
                            }

                            public void run() {
                                IdentifyMavenDependencyPage.this.select(selection.toList(), true);
                            }
                        });
                    }
                    if (showUnSelect) {
                        manager.add((IAction)new Action(){

                            public String getText() {
                                return "Deselect";
                            }

                            public void run() {
                                IdentifyMavenDependencyPage.this.select(selection.toList(), false);
                            }
                        });
                    }
                    manager.add((IAction)new Action(){

                        public String getText() {
                            return "Edit...";
                        }

                        public void run() {
                            IdentifyMavenDependencyPage.this.openDependencyDetails(selection.toList().toArray(new ProjectDependency[selection.size()]));
                        }
                    });
                }
            }
        });
        this.dependenciesViewer.getControl().setMenu(manager.createContextMenu(this.dependenciesViewer.getControl()));
    }

    protected void openDependencyDetails(ProjectDependency ... selectedDeps) {
        int n;
        Dependency editedDep;
        boolean multipleSelection;
        if (selectedDeps.length == 0) {
            return;
        }
        boolean bl = multipleSelection = selectedDeps.length > 1;
        if (multipleSelection) {
            editedDep = new Dependency();
            editedDep.setGroupId(MULTIPLE_DEPENDENCIES_TEXT);
            editedDep.setArtifactId(MULTIPLE_DEPENDENCIES_TEXT);
            String defaultScope = null;
            ProjectDependency[] projectDependencyArray = selectedDeps;
            n = selectedDeps.length;
            int n2 = 0;
            while (n2 < n) {
                ProjectDependency pd = projectDependencyArray[n2];
                Dependency d = this.dependencyMap.get(pd);
                if (d != null) {
                    if (defaultScope != null && !defaultScope.equals(d.getScope())) {
                        defaultScope = null;
                        break;
                    }
                    defaultScope = d.getScope();
                }
                ++n2;
            }
            editedDep.setScope(defaultScope);
        } else {
            editedDep = this.dependencyMap.get(selectedDeps[0]);
        }
        EditDependencyDialog editDependencyDialog = new EditDependencyDialog(this.getShell());
        editDependencyDialog.setDependency(editedDep);
        editDependencyDialog.setRestrictedModification(multipleSelection);
        if (editDependencyDialog.open() == 0) {
            Dependency newDep = editDependencyDialog.getDependency();
            if (multipleSelection) {
                ProjectDependency[] projectDependencyArray = selectedDeps;
                int n3 = selectedDeps.length;
                n = 0;
                while (n < n3) {
                    ProjectDependency pd = projectDependencyArray[n];
                    Dependency updatedDep = this.dependencyMap.get(pd);
                    if (updatedDep != null) {
                        updatedDep.setScope(newDep.getScope());
                    }
                    this.refresh(pd);
                    ++n;
                }
            } else {
                this.dependencyMap.put(selectedDeps[0], newDep);
                if (!(newDep == null || editedDep != null && IdentifyMavenDependencyPage.getKey(newDep).equals(IdentifyMavenDependencyPage.getKey(editedDep)))) {
                    this.resolve(selectedDeps[0], newDep);
                }
                this.refresh(selectedDeps[0]);
            }
        }
    }

    private void resolve(ProjectDependency projectDependency, Dependency d) {
        if (d != null) {
            IdentificationJob job = this.identificationJobs.get(projectDependency);
            job.setDependency(d);
            job.setRequestedProcess(IdentificationJob.Task.RESOLUTION_ONLY);
            job.schedule();
        }
    }

    public boolean hasNoRunningJobs() {
        for (IdentificationJob job : this.identificationJobs.values()) {
            if (job.getState() != 4 && job.getState() != 2) continue;
            return false;
        }
        return true;
    }

    private Button addSelectionButton(Composite container, String label, final boolean ischecked) {
        Button button = new Button(container, 0);
        button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        button.setText(label);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<ProjectDependency> selection = new ArrayList<ProjectDependency>(IdentifyMavenDependencyPage.this.dependenciesViewer.getTable().getItems().length);
                TableItem[] tableItemArray = IdentifyMavenDependencyPage.this.dependenciesViewer.getTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    selection.add((ProjectDependency)item.getData());
                    ++n2;
                }
                IdentifyMavenDependencyPage.this.select(selection, ischecked);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return button;
    }

    private void select(Collection<ProjectDependency> selection, boolean ischecked) {
        for (ProjectDependency pd : selection) {
            this.dependencyCheckStateMap.put(pd, ischecked);
            this.dependenciesViewer.setChecked((Object)pd, ischecked);
        }
        this.refresh();
    }

    private Button addEditButton(Composite container, String label) {
        Button button = new Button(container, 0);
        button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        button.setText(label);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = IdentifyMavenDependencyPage.this.dependenciesViewer.getTable().getSelection();
                ArrayList<ProjectDependency> selectedDeps = new ArrayList<ProjectDependency>(selection.length);
                TableItem[] tableItemArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    ProjectDependency projectDep = (ProjectDependency)item.getData();
                    IdentificationJob job = (IdentificationJob)((Object)IdentifyMavenDependencyPage.this.identificationJobs.get(projectDep));
                    if (4 == job.getState()) {
                        return;
                    }
                    selectedDeps.add(projectDep);
                    ++n2;
                }
                ProjectDependency[] pdArray = new ProjectDependency[selectedDeps.size()];
                IdentifyMavenDependencyPage.this.openDependencyDetails(selectedDeps.toArray(pdArray));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return button;
    }

    private void addStopButton(Composite container, String label) {
        this.stopButton = new Button(container, 0);
        this.stopButton.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.stopButton.setText(label);
        this.stopButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IdentifyMavenDependencyPage.this.cancel();
                IdentifyMavenDependencyPage.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void addIdentifyButton(Composite container, String label) {
        this.startIdentification = new Button(container, 0);
        this.startIdentification.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.startIdentification.setText(label);
        this.startIdentification.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IdentifyMavenDependencyPage.this.runIdentificationJobs(null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    protected void runIdentificationJobs(IProgressMonitor monitor) {
        this.initJobs();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        for (Map.Entry<ProjectDependency, Dependency> entry : this.dependencyMap.entrySet()) {
            entry.getValue();
            IdentificationJob job = this.identificationJobs.get(entry.getKey());
            if (job == null) continue;
            job.setProgressGroup(monitor, 1);
            int jobState = job.getState();
            if (jobState != 0) continue;
            job.setRequestedProcess(IdentificationJob.Task.ALL);
            job.schedule();
        }
        this.refresh();
    }

    private synchronized void refresh() {
        this.enableIdentificationButtons();
        this.displayWarning();
        this.setPageComplete(this.hasNoRunningJobs());
    }

    private void displayWarning() {
        for (Dependency d : this.getDependencies()) {
            if (this.isResolved(d)) continue;
            this.setVisible((Control)this.warningImg, true);
            this.setVisible((Control)this.warningLink, true);
            return;
        }
        this.setVisible((Control)this.warningImg, false);
        this.setVisible((Control)this.warningLink, false);
    }

    private void setVisible(Control control, boolean visible) {
        if (control != null && !control.isDisposed()) {
            control.setVisible(visible);
        }
    }

    private void enableIdentificationButtons() {
        boolean hasNoRunningJobs = this.hasNoRunningJobs();
        if (this.startIdentification != null && !this.startIdentification.isDisposed()) {
            this.startIdentification.setEnabled(hasNoRunningJobs);
        }
        if (this.stopButton != null && !this.stopButton.isDisposed()) {
            this.stopButton.setEnabled(!hasNoRunningJobs);
        }
        if (this.dependenciesViewer != null && !this.dependenciesViewer.getTable().isDisposed()) {
            this.dependenciesViewer.refresh();
        }
    }

    private void initJobs() {
        if (this.identificationJobs == null) {
            this.identificationJobs = new HashMap<ProjectDependency, IdentificationJob>(this.dependencyMap.size());
            Table t = this.dependenciesViewer.getTable();
            FileIdentificationManager fileIdentificationManager = new FileIdentificationManager();
            TableItem[] tableItemArray = t.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                final ProjectDependency projectDep = (ProjectDependency)item.getData();
                Dependency mavenDep = this.dependencyMap.get(projectDep);
                if (mavenDep == null) {
                    try {
                        IdentificationJob job;
                        if (projectDep.getDependencyKind() == ProjectDependency.DependencyKind.Project) {
                            job = new IdentifyProjectJob("Search the Maven coordinates for " + projectDep.getPath(), projectDep.getPath());
                        } else if (projectDep.getDependencyKind() == ProjectDependency.DependencyKind.Archive) {
                            File jar = ConversionUtils.getFile(projectDep.getPath());
                            job = new IdentifyJarJob("Search the Maven coordinates for " + jar.getAbsolutePath(), (IFileIdentificationManager)fileIdentificationManager, jar);
                        } else {
                            job = new DependencyResolutionJob("Resolve the Maven dependency for " + projectDep.getPath());
                        }
                        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                            public void running(IJobChangeEvent event) {
                                this.refreshUI();
                            }

                            public void done(IJobChangeEvent event) {
                                if (IdentifyMavenDependencyPage.this.dependencyMap == null || IdentifyMavenDependencyPage.this.dependencyResolution == null || event.getResult().getSeverity() == 8) {
                                    return;
                                }
                                Dependency d = job.getDependency();
                                IdentifyMavenDependencyPage.this.dependencyMap.put(projectDep, d);
                                if (d != null) {
                                    IdentifyMavenDependencyPage.this.dependencyResolution.put(IdentifyMavenDependencyPage.getKey(d), job.isResolvable());
                                }
                                this.refreshUI();
                            }

                            private void refreshUI() {
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        IdentifyMavenDependencyPage.this.refresh(projectDep);
                                    }
                                });
                            }
                        });
                        this.identificationJobs.put(projectDep, job);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
    }

    protected static String getKey(Dependency d) {
        String type;
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.defaultString((Object)d.getGroupId())).append(":");
        sb.append(StringUtils.defaultString((Object)d.getArtifactId())).append(":");
        sb.append(StringUtils.defaultString((Object)d.getVersion())).append(":");
        if (StringUtils.isNotEmpty((String)d.getClassifier())) {
            sb.append(d.getClassifier()).append(":");
        }
        if ((type = d.getType()) == null || type.isEmpty()) {
            type = "jar";
        }
        sb.append(type);
        return sb.toString();
    }

    private synchronized void refresh(ProjectDependency key) {
        if (this.dependenciesViewer == null || this.dependenciesViewer.getTable().isDisposed()) {
            return;
        }
        try {
            TableItem[] tableItemArray = this.dependenciesViewer.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                ProjectDependency projectDep = (ProjectDependency)item.getData();
                if (projectDep.equals(key)) {
                    Job job;
                    this.dependenciesViewer.refresh((Object)projectDep, false);
                    if (this.dependencyMap.get(projectDep) == null && (job = (Job)this.identificationJobs.get(projectDep)) != null && job.getState() == 0) {
                        this.dependenciesViewer.setChecked((Object)projectDep, false);
                    }
                    this.setPageComplete(this.hasNoRunningJobs());
                    return;
                }
                ++n2;
            }
        }
        finally {
            this.displayWarning();
            this.enableIdentificationButtons();
        }
    }

    public List<Dependency> getDependencies() {
        List<ProjectDependency> checkedProjectDependencies = this.getCheckedProjectDependencies();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(checkedProjectDependencies.size());
        for (ProjectDependency projectDep : checkedProjectDependencies) {
            Dependency d = this.dependencyMap.get(projectDep);
            if (d == null) continue;
            dependencies.add(d);
        }
        return dependencies;
    }

    public List<ProjectDependency> getCheckedProjectDependencies() {
        ArrayList<ProjectDependency> selectedDeps = new ArrayList<ProjectDependency>(this.dependencyCheckStateMap.size());
        for (Map.Entry<ProjectDependency, Boolean> entry : this.dependencyCheckStateMap.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().booleanValue()) continue;
            selectedDeps.add(entry.getKey());
        }
        return selectedDeps;
    }

    public boolean isDeleteJars() {
        return this.deleteJars;
    }

    private boolean isResolved(Dependency d) {
        if (d == null) {
            return false;
        }
        Boolean resolved = this.dependencyResolution.get(IdentifyMavenDependencyPage.getKey(d));
        return resolved == null ? false : resolved;
    }

    public void cancel() {
        for (IdentificationJob job : this.identificationJobs.values()) {
            job.cancel();
        }
    }

    public IResource[] getResourcesToDelete() {
        ArrayList<IFile> resources = new ArrayList<IFile>(this.dependencyMap.size());
        IPath projectPath = this.project.getLocation();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (ProjectDependency pd : this.dependencyMap.keySet()) {
            IFile f;
            if (pd.getDependencyKind() != ProjectDependency.DependencyKind.Archive) continue;
            IPath p = pd.getPath();
            if (projectPath.isPrefixOf(p)) {
                p = p.removeFirstSegments(projectPath.segmentCount() - 1);
            }
            if (!(f = root.getFile(p)).exists() || !this.project.equals((Object)f.getProject())) continue;
            resources.add(f);
        }
        return resources.toArray(new IResource[0]);
    }

    private String getLabel(ProjectDependency projectDependency) {
        return projectDependency.getPath().lastSegment();
    }

    private class DependencyLabelProvider
    extends ColumnLabelProvider {
        private DependencyLabelProvider() {
        }

        public String getText(Object element) {
            int jobState;
            IdentificationJob job;
            ProjectDependency projectDep = (ProjectDependency)element;
            IdentificationJob identificationJob = job = IdentifyMavenDependencyPage.this.identificationJobs == null ? null : (IdentificationJob)((Object)IdentifyMavenDependencyPage.this.identificationJobs.get(projectDep));
            if (job != null && ((jobState = job.getState()) == 4 || jobState == 2)) {
                return "Identification in progress...";
            }
            Dependency d = (Dependency)IdentifyMavenDependencyPage.this.dependencyMap.get(projectDep);
            if (d == null) {
                return "Unidentified dependency";
            }
            StringBuilder label = new StringBuilder(IdentifyMavenDependencyPage.getKey(d));
            if (StringUtils.isNotBlank((String)d.getScope()) && !"compile".equals(d.getScope())) {
                label.append(" [").append(d.getScope()).append("]");
            }
            if (d.isOptional() && ("compile".equals(d.getScope()) || "runtime".equals(d.getScope()))) {
                label.append(" (optional)");
            }
            return label.toString();
        }

        public Image getImage(Object element) {
            int jobState;
            IdentificationJob job;
            ProjectDependency projectDep = (ProjectDependency)element;
            IdentificationJob identificationJob = job = IdentifyMavenDependencyPage.this.identificationJobs == null ? null : (IdentificationJob)((Object)IdentifyMavenDependencyPage.this.identificationJobs.get(projectDep));
            if (job != null && ((jobState = job.getState()) == 4 || jobState == 2)) {
                return IdentifyMavenDependencyPage.this.loadingImage;
            }
            Dependency d = (Dependency)IdentifyMavenDependencyPage.this.dependencyMap.get(projectDep);
            if (d == null) {
                return IdentifyMavenDependencyPage.this.failedImage;
            }
            Image img = IdentifyMavenDependencyPage.this.isResolved(d) ? IdentifyMavenDependencyPage.this.okImage : IdentifyMavenDependencyPage.this.unresolvedImage;
            return img;
        }
    }

    class DependencyPatternFilter
    extends ViewerFilter {
        private StringMatcher matcher;

        DependencyPatternFilter() {
        }

        public void setPattern(String searchPattern) {
            if (searchPattern == null || searchPattern.length() == 0) {
                this.matcher = null;
            } else {
                String pattern = "*" + searchPattern + "*";
                this.matcher = new StringMatcher(pattern, true, false);
            }
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            Dependency d;
            ProjectDependency pd;
            if (this.matcher == null) {
                return true;
            }
            boolean match = false;
            if (element instanceof ProjectDependency && !(match = this.matcher.match(IdentifyMavenDependencyPage.this.getLabel(pd = (ProjectDependency)element))) && (d = (Dependency)IdentifyMavenDependencyPage.this.dependencyMap.get(pd)) != null) {
                match = this.matcher.match(String.valueOf(d.getGroupId()) + ":" + d.getArtifactId());
            }
            return match;
        }
    }
}

