/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.conversion.ui.dialog.xpl;

import org.apache.maven.model.Dependency;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.util.M2EUIUtils;
import org.eclipse.m2e.core.ui.internal.util.Util;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class EditDependencyDialog
extends SelectionStatusDialog {
    private static final String[] TYPES = new String[]{"jar", "war", "rar", "ear", "par", "ejb", "ejb-client", "test-jar", "java-source", "javadoc", "maven-plugin", "pom"};
    private String[] scopes = new String[]{"compile", "provided", "runtime", "test", "system"};
    protected Text groupIdText;
    protected Text artifactIdText;
    protected Text versionText;
    protected Text classifierText;
    protected Combo typeCombo;
    protected Combo scopeCombo;
    protected Text systemPathText;
    protected Button optionalButton;
    private Dependency dependency;
    private boolean restrictedModification;

    public EditDependencyDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle("Edit dependency");
    }

    protected Control createDialogArea(Composite parent) {
        Composite superComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(superComposite, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label groupIdLabel = new Label(composite, 0);
        groupIdLabel.setText(Messages.EditDependencyDialog_groupId_label);
        boolean enabled = !this.restrictedModification;
        this.groupIdText = new Text(composite, 2048);
        GridData gd_groupIdText = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_groupIdText.horizontalIndent = 4;
        this.groupIdText.setLayoutData((Object)gd_groupIdText);
        M2EUIUtils.addRequiredDecoration((Control)this.groupIdText);
        this.groupIdText.setEnabled(enabled);
        Label artifactIdLabel = new Label(composite, 0);
        artifactIdLabel.setText("Artifact Id");
        this.artifactIdText = new Text(composite, 2048);
        GridData gd_artifactIdText = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_artifactIdText.horizontalIndent = 4;
        this.artifactIdText.setLayoutData((Object)gd_artifactIdText);
        M2EUIUtils.addRequiredDecoration((Control)this.artifactIdText);
        this.artifactIdText.setEnabled(enabled);
        Label versionLabel = new Label(composite, 0);
        versionLabel.setText(Messages.EditDependencyDialog_version_label);
        this.versionText = new Text(composite, 2048);
        GridData versionTextData = new GridData(16384, 0x1000000, true, false, 2, 1);
        versionTextData.horizontalIndent = 4;
        versionTextData.widthHint = 200;
        this.versionText.setLayoutData((Object)versionTextData);
        this.versionText.setEnabled(enabled);
        Label classifierLabel = new Label(composite, 0);
        classifierLabel.setText(Messages.EditDependencyDialog_classifier_label);
        this.classifierText = new Text(composite, 2048);
        GridData gd_classifierText = new GridData(16384, 0x1000000, true, false, 2, 1);
        gd_classifierText.horizontalIndent = 4;
        gd_classifierText.widthHint = 200;
        this.classifierText.setLayoutData((Object)gd_classifierText);
        this.classifierText.setEnabled(enabled);
        Label typeLabel = new Label(composite, 0);
        typeLabel.setText(Messages.EditDependencyDialog_type_label);
        this.typeCombo = new Combo(composite, 0);
        this.typeCombo.setItems(TYPES);
        GridData gd_typeText = new GridData(16384, 0x1000000, true, false, 2, 1);
        gd_typeText.horizontalIndent = 4;
        gd_typeText.widthHint = 120;
        this.typeCombo.setLayoutData((Object)gd_typeText);
        this.typeCombo.setEnabled(enabled);
        Label scopeLabel = new Label(composite, 0);
        scopeLabel.setText(Messages.EditDependencyDialog_scope_label);
        this.scopeCombo = new Combo(composite, 0);
        this.scopeCombo.setItems(this.scopes);
        GridData gd_scopeText = new GridData(16384, 0x1000000, true, false, 2, 1);
        gd_scopeText.horizontalIndent = 4;
        gd_scopeText.widthHint = 120;
        this.scopeCombo.setLayoutData((Object)gd_scopeText);
        Label systemPathLabel = new Label(composite, 0);
        systemPathLabel.setText(Messages.EditDependencyDialog_systemPath_label);
        this.systemPathText = new Text(composite, 2048);
        GridData gd_systemPathText = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_systemPathText.horizontalIndent = 4;
        gd_systemPathText.widthHint = 200;
        this.systemPathText.setLayoutData((Object)gd_systemPathText);
        this.systemPathText.setEnabled(enabled);
        new Label(composite, 0);
        this.optionalButton = new Button(composite, 32);
        this.optionalButton.setText(Messages.EditDependencyDialog_optional_checkbox);
        GridData gd_optionalButton = new GridData(16384, 128, false, false, 2, 1);
        gd_optionalButton.horizontalIndent = 4;
        this.optionalButton.setLayoutData((Object)gd_optionalButton);
        this.optionalButton.setEnabled(enabled);
        composite.setTabList(new Control[]{this.groupIdText, this.artifactIdText, this.versionText, this.classifierText, this.typeCombo, this.scopeCombo, this.systemPathText, this.optionalButton});
        this.setDependency(this.dependency);
        return superComposite;
    }

    protected void computeResult() {
        if (this.dependency == null) {
            this.dependency = new Dependency();
        }
        String groupId = this.valueOrNull(this.groupIdText.getText());
        String artifactId = this.valueOrNull(this.artifactIdText.getText());
        String version = this.valueOrNull(this.versionText.getText());
        String type = this.valueOrNull(this.typeCombo.getText());
        type = type == null ? "jar" : type;
        String scope = this.valueOrNull(this.scopeCombo.getText());
        String classifier = this.valueOrNull(this.classifierText.getText());
        String system = this.valueOrNull(this.systemPathText.getText());
        this.dependency.setArtifactId(artifactId);
        this.dependency.setGroupId(groupId);
        this.dependency.setType(type);
        this.dependency.setVersion(version);
        this.dependency.setScope("compile".equals(scope) ? "" : scope);
        this.dependency.setClassifier(classifier);
        this.dependency.setSystemPath(system);
        boolean optional = this.optionalButton.getSelection();
        if (optional != this.dependency.isOptional()) {
            this.dependency.setOptional(optional);
        }
    }

    private String valueOrNull(String value) {
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    public void setDependency(Dependency dependency) {
        Dependency dependency2 = this.dependency = dependency == null ? null : dependency.clone();
        if (dependency != null && this.groupIdText != null && !this.groupIdText.isDisposed()) {
            this.groupIdText.setText(Util.nvl((String)dependency.getGroupId()));
            this.artifactIdText.setText(Util.nvl((String)dependency.getArtifactId()));
            this.versionText.setText(Util.nvl((String)dependency.getVersion()));
            this.classifierText.setText(Util.nvl((String)dependency.getClassifier()));
            this.typeCombo.setText("".equals(Util.nvl((String)dependency.getType())) ? "jar" : dependency.getType());
            this.scopeCombo.setText("".equals(Util.nvl((String)dependency.getScope())) ? "compile" : dependency.getScope());
            this.systemPathText.setText(Util.nvl((String)dependency.getSystemPath()));
            boolean optional = Boolean.parseBoolean(dependency.getOptional());
            if (this.optionalButton.getSelection() != optional) {
                this.optionalButton.setSelection(optional);
            }
        }
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public boolean isRestrictedModification() {
        return this.restrictedModification;
    }

    public void setRestrictedModification(boolean restrictModification) {
        this.restrictedModification = restrictModification;
    }
}

