/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.conversion.ui.internal.jobs;

import java.io.File;
import org.apache.maven.model.Dependency;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.jboss.tools.maven.conversion.ui.internal.jobs.IdentificationJob;
import org.jboss.tools.maven.core.identification.IFileIdentificationManager;

public class IdentifyJarJob
extends IdentificationJob {
    private File file;
    private IFileIdentificationManager fileIdentificationManager;

    public IdentifyJarJob(String name, IFileIdentificationManager fileIdentificationManager, File file) {
        super(name);
        this.fileIdentificationManager = fileIdentificationManager;
        this.file = file;
        this.setRequestedProcess(IdentificationJob.Task.ALL);
    }

    @Override
    protected void identifyDependency(IProgressMonitor monitor) throws CoreException {
        monitor.subTask("Identifying " + this.file);
        ArtifactKey artifactKey = this.fileIdentificationManager.identify(this.file, monitor);
        if (artifactKey != null) {
            this.dependency = new Dependency();
            this.dependency.setArtifactId(artifactKey.getArtifactId());
            this.dependency.setGroupId(artifactKey.getGroupId());
            this.dependency.setVersion(artifactKey.getVersion());
            this.dependency.setClassifier(artifactKey.getClassifier());
        }
    }
}

