/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.jboss.tools.maven.core.MavenCoreActivator;

public class MavenUtil {
    public static void refreshParent(MavenProject mavenProject) throws CoreException {
        IMavenProjectFacade parentFacade;
        if (mavenProject == null || mavenProject.getModel() == null) {
            return;
        }
        Parent parent = mavenProject.getModel().getParent();
        if (parent != null && (parentFacade = MavenPlugin.getMavenProjectRegistry().getMavenProject(parent.getGroupId(), parent.getArtifactId(), parent.getVersion())) != null) {
            parentFacade.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static Model getModel(IProject project) throws CoreException {
        IFile pom = project.getFile("pom.xml");
        Model model = null;
        if (pom.exists()) {
            MavenModelManager modelManager = MavenPlugin.getMavenModelManager();
            model = modelManager.readMavenModel(pom);
        }
        return model;
    }

    public static Dependency createDependency(String groupId, String artifactId, String version) {
        return MavenUtil.createDependency(groupId, artifactId, version, null);
    }

    public static Dependency createDependency(String groupId, String artifactId, String version, String type) {
        Dependency d = new Dependency();
        d.setGroupId(groupId);
        d.setArtifactId(artifactId);
        d.setVersion(version);
        d.setType(type);
        return d;
    }

    public static String getDependencyVersion(MavenProject mavenProject, String gid, String aid) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        ScopeArtifactFilter filter = new ScopeArtifactFilter("test");
        for (Artifact artifact : mavenProject.getArtifacts()) {
            if (!filter.include(artifact)) continue;
            artifacts.add(artifact);
        }
        for (Artifact artifact : artifacts) {
            String artifactId;
            String groupId = artifact.getGroupId();
            if (groupId == null || !groupId.equals(gid) || (artifactId = artifact.getArtifactId()) == null || !artifactId.equals(aid)) continue;
            return artifact.getVersion();
        }
        return null;
    }

    public static String getDependencyVersion(Artifact artifact, List<ArtifactRepository> remoteRepos, String gid, String aid) {
        IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getMavenProject(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        if (facade != null) {
            return MavenUtil.getDependencyVersion(facade.getMavenProject(), gid, aid);
        }
        File pom = MavenUtil.getPomFile(artifact);
        String version = null;
        if (pom != null) {
            MavenProject mavenProject = null;
            MavenImpl maven = (MavenImpl)MavenPlugin.getMaven();
            try {
                NullProgressMonitor monitor = new NullProgressMonitor();
                MavenExecutionRequest request = maven.createExecutionRequest((IProgressMonitor)monitor);
                for (ArtifactRepository repo : remoteRepos) {
                    request.addRemoteRepository(repo);
                }
                request.setPom(pom);
                request.getProjectBuildingRequest().setResolveDependencies(true);
                MavenExecutionResult result = maven.readProject(request, (IProgressMonitor)monitor);
                if (result.hasExceptions()) {
                    for (Throwable e : result.getExceptions()) {
                        MavenCoreActivator.log(e);
                    }
                } else {
                    mavenProject = result.getProject();
                    if (mavenProject != null) {
                        version = MavenUtil.getDependencyVersion(mavenProject, gid, aid);
                        maven.detachFromSession(mavenProject);
                    }
                }
            }
            catch (CoreException e) {
                MavenCoreActivator.log(e);
            }
        }
        return version;
    }

    private static File getPomFile(Artifact artifact) {
        String pomPath;
        File pomFile;
        String path;
        int lastIndexOfDot;
        File artifactFile = artifact.getFile();
        if (artifactFile != null && (lastIndexOfDot = (path = artifactFile.getAbsolutePath()).lastIndexOf(".")) > 0 && (pomFile = new File(pomPath = String.valueOf(path.substring(0, lastIndexOfDot)) + ".pom")).exists() && pomFile.canRead()) {
            return pomFile;
        }
        return null;
    }

    public static Artifact createArtifact(String coordinates) {
        Pattern p = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?:([^: ]+)");
        Matcher m = p.matcher(coordinates);
        if (!m.matches()) {
            throw new IllegalArgumentException("Bad artifact coordinates " + coordinates + ", expected format is <groupId>:<artifactId>[:<type>[:<classifier>]]:<version>");
        }
        String groupId = m.group(1);
        String artifactId = m.group(2);
        String type = StringUtils.defaultString((Object)m.group(4), (String)"jar");
        String classifier = StringUtils.defaultString((Object)m.group(6), (String)"");
        String version = m.group(7);
        return MavenUtil.createArtifact(groupId, artifactId, version, type, classifier);
    }

    public static Artifact createArtifact(String groupId, String artifactId, String version, String type, String classifier) {
        return MavenUtil.getRepositorySystem().createArtifactWithClassifier(groupId, artifactId, version, type == null ? "jar" : type, classifier);
    }

    public static RepositorySystem getRepositorySystem() {
        RepositorySystem repositorySystem;
        try {
            repositorySystem = (RepositorySystem)MavenPluginActivator.getDefault().getPlexusContainer().lookup(RepositorySystem.class);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(e);
        }
        return repositorySystem;
    }
}

