/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.core.internal.identification;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.jboss.tools.common.util.HttpUtil;
import org.jboss.tools.maven.core.MavenCoreActivator;
import org.jboss.tools.maven.core.identification.IdentificationUtil;
import org.jboss.tools.maven.core.internal.identification.AbstractArtifactIdentifier;
import org.jboss.tools.maven.core.repositories.NexusRepository;
import org.jboss.tools.maven.core.repositories.RemoteRepositoryManager;
import org.sonatype.nexus.rest.model.NexusArtifact;
import org.sonatype.nexus.rest.model.SearchResponse;

public class NexusRepositoryIdentifier
extends AbstractArtifactIdentifier {
    public NexusRepositoryIdentifier() {
        super("Nexus repository identifier");
    }

    @Override
    public ArtifactKey identify(File file) throws CoreException {
        return this.getArtifactFromRemoteNexusRepository(file, null);
    }

    @Override
    public ArtifactKey identify(File file, IProgressMonitor monitor) throws CoreException {
        return this.getArtifactFromRemoteNexusRepository(file, monitor);
    }

    private ArtifactKey getArtifactFromRemoteNexusRepository(File file, IProgressMonitor monitor) {
        String sha1;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            return null;
        }
        try {
            sha1 = IdentificationUtil.getSHA1(file);
        }
        catch (Exception e) {
            return null;
        }
        RemoteRepositoryManager repoManager = MavenCoreActivator.getDefault().getRepositoryManager();
        LinkedHashSet<NexusRepository> nexusRepositories = new LinkedHashSet<NexusRepository>(repoManager.getNexusRepositories());
        for (NexusRepository repository : nexusRepositories) {
            if (monitor.isCanceled()) {
                return null;
            }
            if (!repository.isEnabled()) continue;
            monitor.setTaskName("Querying " + repository.getUrl() + " for " + file.getName());
            try {
                ArtifactKey key = NexusRepositoryIdentifier.searchArtifactFromRemoteNexusRepository(repository.getSearchUrl(sha1));
                if (key == null) continue;
                return key;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static ArtifactKey searchArtifactFromRemoteNexusRepository(String searchUrl) {
        if (searchUrl == null) {
            return null;
        }
        InputStream is = null;
        try {
            is = HttpUtil.getInputStreamFromUrlByGetMethod((String)searchUrl);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SearchResponse.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object object = unmarshaller.unmarshal(is);
            if (object instanceof SearchResponse) {
                ArtifactKey artifactKey = NexusRepositoryIdentifier.extractArtifactKey((SearchResponse)object);
                return artifactKey;
            }
        }
        catch (IOException ioe) {
            System.err.println("NexusRepositoryIdentifier can't connect to remote repository " + searchUrl + " : " + ioe.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtil.close((InputStream)is);
        }
        return null;
    }

    private static ArtifactKey extractArtifactKey(SearchResponse searchResponse) {
        Iterator iterator = searchResponse.getData().iterator();
        if (iterator.hasNext()) {
            NexusArtifact nexusArtifact = (NexusArtifact)iterator.next();
            String groupId = nexusArtifact.getGroupId();
            String artifactId = nexusArtifact.getArtifactId();
            String version = nexusArtifact.getVersion();
            String classifier = nexusArtifact.getClassifier();
            ArtifactKey artifact = new ArtifactKey(groupId, artifactId, version, classifier);
            return artifact;
        }
        return null;
    }
}

