/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.jdt.configurators;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.eclipse.m2e.core.internal.markers.SourceLocationHelper;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IJavaProjectConfigurator;
import org.jboss.tools.maven.jdt.MavenJdtActivator;
import org.jboss.tools.maven.jdt.endorsedlib.IEndorsedLibrariesManager;
import org.jboss.tools.maven.jdt.utils.ClasspathHelpers;

public class EndorsedLibProjectConfigurator
extends AbstractProjectConfigurator
implements IJavaProjectConfigurator {
    private static final String MISSING_ENDORSED_DIRS_MARKER = "org.jbosstools.maven.configuration.jdt.endorsedlib";

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        this.markerManager.deleteMarkers((IResource)request.getProject(), MISSING_ENDORSED_DIRS_MARKER);
        IMavenProjectFacade mavenProjectFacade = request.getMavenProjectFacade();
        File[] endorsedDirs = this.getEndorsedDirs(mavenProjectFacade, monitor);
        if (endorsedDirs == null || endorsedDirs.length == 0) {
            return;
        }
        Set<File> missingEndorsedDir = this.checkMissingDirs(endorsedDirs);
        if (!missingEndorsedDir.isEmpty()) {
            MojoExecutionKey key = new MojoExecutionKey("org.apache.maven.plugins", "maven-compiler-plugin", null, null, null, null);
            SourceLocation sourceLocation = SourceLocationHelper.findLocation((MavenProject)mavenProjectFacade.getMavenProject(), (MojoExecutionKey)key);
            for (File dir : missingEndorsedDir) {
                this.addMissingDirWarning(request.getProject(), sourceLocation, dir);
            }
        }
    }

    private void addMissingDirWarning(IProject project, SourceLocation sourceLocation, File dir) throws CoreException {
        IMarker marker = this.markerManager.addMarker((IResource)project.getFile("pom.xml"), MISSING_ENDORSED_DIRS_MARKER, "Endorsed directory '" + dir.getAbsolutePath() + "' is missing. " + "You may need to a perform a Maven command line build in order to create it.", sourceLocation.getLineNumber(), 2);
        marker.setAttribute("outputDirectory", (Object)dir.getAbsolutePath());
    }

    private Set<File> checkMissingDirs(File[] endorsedDirs) {
        HashSet<File> missingDirs = new HashSet<File>(endorsedDirs.length);
        File[] fileArray = endorsedDirs;
        int n = endorsedDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            if (!dir.exists()) {
                missingDirs.add(dir);
            }
            ++n2;
        }
        return missingDirs;
    }

    public void configureClasspath(IMavenProjectFacade facade, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
    }

    public void configureRawClasspath(ProjectConfigurationRequest request, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)request.getProject());
        if (javaProject == null) {
            return;
        }
        File[] endorsedDirs = this.getEndorsedDirs(request.getMavenProjectFacade(), monitor);
        if (endorsedDirs == null || endorsedDirs.length == 0) {
            ClasspathHelpers.removeEndorsedLibClasspathContainer(classpath);
            return;
        }
        this.getEndorsedLibrariesManager().configureEndorsedLibs(javaProject, classpath, endorsedDirs, monitor);
    }

    private File[] getEndorsedDirs(IMavenProjectFacade mavenProjectFacade, IProgressMonitor monitor) throws CoreException {
        MavenSession session = this.createSession(mavenProjectFacade, monitor);
        MojoExecution mojoExecution = this.getCompilerMojoExecution(mavenProjectFacade, session, monitor);
        String compilerArgument = (String)this.maven.getMojoParameterValue(session, mojoExecution, "compilerArgument", String.class);
        File[] javaEndorsedDirs = this.parseJavaEndorsedDirs(mavenProjectFacade.getProject(), compilerArgument);
        Map compilerArguments = (Map)this.maven.getMojoParameterValue(session, mojoExecution, "compilerArguments", Map.class);
        String endorsedDirsArg = compilerArguments == null ? null : (String)compilerArguments.get("endorseddirs");
        File[] endorsedDirs = this.parseEndorsedDirs(mavenProjectFacade.getProject(), endorsedDirsArg);
        return EndorsedLibProjectConfigurator.concat(javaEndorsedDirs, endorsedDirs);
    }

    private File[] parseJavaEndorsedDirs(IProject project, String compilerArgument) {
        if (compilerArgument == null) {
            return null;
        }
        String key = "-Djava.endorsed.dirs=";
        int start = compilerArgument.indexOf(key);
        if (start < 0) {
            return null;
        }
        File[] dirs = null;
        int end = compilerArgument.indexOf("\"", start);
        if (end < 0 && (end = compilerArgument.indexOf(" ", start)) < 0) {
            end = compilerArgument.length();
        }
        if (end > 0) {
            String argument = compilerArgument.substring(start + key.length(), end);
            dirs = this.parseEndorsedDirs(project, argument);
        }
        return dirs;
    }

    private File[] parseEndorsedDirs(IProject project, String endorsedDirs) {
        if (endorsedDirs == null) {
            return null;
        }
        endorsedDirs = endorsedDirs.replaceAll("\"", "");
        String[] paths = endorsedDirs.split("" + File.pathSeparatorChar);
        ArrayList<File> dirs = new ArrayList<File>(paths.length);
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            Path p = new Path(EndorsedLibProjectConfigurator.useSystemSeparator(path));
            if (!p.isAbsolute()) {
                p = project.getLocation().append((IPath)p);
            }
            File lib = new File(p.toOSString());
            dirs.add(lib);
            ++n2;
        }
        return dirs.toArray(new File[0]);
    }

    private static String useSystemSeparator(String name) {
        if (name == null) {
            return null;
        }
        return name.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    private MojoExecution getCompilerMojoExecution(IMavenProjectFacade mavenProjectFacade, MavenSession session, IProgressMonitor monitor) throws CoreException {
        MavenExecutionPlan executionPlan = this.maven.calculateExecutionPlan(session, mavenProjectFacade.getMavenProject(monitor), Collections.singletonList("compile"), true, monitor);
        MojoExecution mojoExecution = this.getExecution(executionPlan, "maven-compiler-plugin", "compile");
        return mojoExecution;
    }

    private MavenSession createSession(IMavenProjectFacade mavenProjectFacade, IProgressMonitor monitor) throws CoreException {
        IFile pomResource = mavenProjectFacade.getPom();
        MavenExecutionRequest request = this.projectManager.createExecutionRequest(pomResource, mavenProjectFacade.getResolverConfiguration(), monitor);
        MavenSession session = this.maven.createSession(request, mavenProjectFacade.getMavenProject());
        return session;
    }

    private MojoExecution getExecution(MavenExecutionPlan executionPlan, String artifactId, String goal) throws CoreException {
        for (MojoExecution execution : executionPlan.getMojoExecutions()) {
            if (!artifactId.equals(execution.getArtifactId()) || !goal.equals(execution.getGoal())) continue;
            return execution;
        }
        return null;
    }

    private static <T> T[] concat(T[] first, T[] second) {
        if (second == null) {
            return first;
        }
        if (first == null) {
            return second;
        }
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private IEndorsedLibrariesManager getEndorsedLibrariesManager() {
        return MavenJdtActivator.getDefault().getEndorsedLibrariesManager();
    }

    public void unconfigure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        super.unconfigure(request, monitor);
        ClasspathHelpers.removeEndorsedLibClasspathContainer(request.getProject());
    }
}

