/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.jdt.utils;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IClasspathEntryDescriptor;
import org.eclipse.m2e.jdt.internal.ClasspathEntryDescriptor;

public class ClasspathHelpers {
    public static final String CONTAINER_ID = "org.jboss.tools.maven.jdt.ENDORSED_LIB_CLASSPATH_CONTAINER";

    public static boolean isEndorsedDirsClasspathContainer(IPath containerPath) {
        return containerPath != null && containerPath.segmentCount() > 0 && CONTAINER_ID.equals(containerPath.segment(0));
    }

    public static IClasspathEntry getDefaultContainerEntry() {
        return JavaCore.newContainerEntry((IPath)new Path(CONTAINER_ID));
    }

    public static IClasspathContainer getEndorsedDirsClasspathContainer(IJavaProject project) throws JavaModelException {
        IClasspathEntry[] entries = project.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 5 && ClasspathHelpers.isEndorsedDirsClasspathContainer(entry.getPath())) {
                return JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
            }
            ++i;
        }
        return null;
    }

    public static IClasspathEntry addEndorsedLibClasspathContainer(IClasspathDescriptor classpath) {
        IClasspathEntry cpe = ClasspathHelpers.getDefaultContainerEntry();
        ClasspathEntryDescriptor entry = new ClasspathEntryDescriptor(cpe);
        entry.setClasspathAttribute("org.eclipse.jst.component.nondependency", "");
        classpath.getEntryDescriptors().add(0, entry);
        return cpe;
    }

    public static void removeEndorsedLibClasspathContainer(IClasspathDescriptor classpath) {
        classpath.removeEntry(new IClasspathDescriptor.EntryFilter(){

            public boolean accept(IClasspathEntryDescriptor entry) {
                return ClasspathHelpers.isEndorsedDirsClasspathContainer(entry.getPath());
            }
        });
    }

    public static IClasspathEntry getEndorsedDirsContainerEntry(IJavaProject javaProject) {
        if (javaProject != null) {
            try {
                IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (ClasspathHelpers.isEndorsedDirsClasspathContainer(entry.getPath())) {
                        return entry;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException ex) {
                return null;
            }
        }
        return null;
    }

    public static void removeEndorsedLibClasspathContainer(IProject project) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (!ClasspathHelpers.isEndorsedDirsClasspathContainer(entry.getPath())) {
                    newEntries.add(entry);
                }
                ++n2;
            }
            javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), null);
        }
    }
}

