/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.project.examples.wizard;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.maven.core.MavenCoreActivator;
import org.jboss.tools.maven.core.settings.MavenSettingsChangeListener;
import org.jboss.tools.maven.project.examples.utils.MavenArtifactHelper;
import org.jboss.tools.maven.project.examples.wizard.MissingRepositoryWarningComponent;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectExampleWorkingCopy;
import org.jboss.tools.project.examples.wizard.NewProjectExamplesRequirementsPage;

public class MavenExamplesRequirementsPage
extends NewProjectExamplesRequirementsPage
implements MavenSettingsChangeListener {
    private static final String PAGE_NAME = "org.jboss.tools.project.examples.mavenrequirements";
    protected MissingRepositoryWarningComponent warningComponent;
    private IStatus enterpriseRepoStatus;

    public MavenExamplesRequirementsPage() {
        this(PAGE_NAME, null);
    }

    public MavenExamplesRequirementsPage(String pageName, ProjectExampleWorkingCopy example) {
        super(pageName, example);
    }

    public String getProjectExampleType() {
        return "maven";
    }

    public void setProjectExample(ProjectExampleWorkingCopy projectExample) {
        super.setProjectExample(projectExample);
        this.validateEnterpriseRepo();
    }

    protected void setAdditionalControls(Composite composite) {
        this.warningComponent = new MissingRepositoryWarningComponent(composite);
        MavenCoreActivator.getDefault().registerMavenSettingsChangeListener((MavenSettingsChangeListener)this);
    }

    public void dispose() {
        if (this.warningComponent != null) {
            this.warningComponent.dispose();
        }
        super.dispose();
    }

    protected void validateEnterpriseRepo() {
        if (this.warningComponent != null) {
            this.warningComponent.setLinkText("");
            if (this.enterpriseRepoStatus == null) {
                this.enterpriseRepoStatus = MavenArtifactHelper.checkRequirementsAvailable((ProjectExample)this.projectExample);
            }
            if (this.enterpriseRepoStatus.isOK()) {
                this.warningComponent.setRepositoryUrls(null);
            } else {
                this.warningComponent.setLinkText(this.enterpriseRepoStatus.getMessage());
            }
        }
    }

    public void onSettingsChanged() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MavenExamplesRequirementsPage.this.enterpriseRepoStatus = null;
                MavenExamplesRequirementsPage.this.validateEnterpriseRepo();
            }
        });
    }
}

