/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.project.examples.xpl;

import java.io.Serializable;
import org.eclipse.osgi.util.NLS;

public class DependencyKey
implements Serializable {
    private static final long serialVersionUID = -8984509272834024387L;
    private final String groupId;
    private final String type;
    private final String artifactId;
    private final String version;
    private final String classifier;

    public DependencyKey(String groupId, String artifactId, String version, String classifier, String type) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DependencyKey) {
            DependencyKey other = (DependencyKey)o;
            return DependencyKey.equals(this.groupId, other.groupId) && DependencyKey.equals(this.artifactId, other.artifactId) && DependencyKey.equals(this.version, other.version) && DependencyKey.equals(this.type, other.type) && DependencyKey.equals(this.classifier, other.classifier);
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + (this.groupId != null ? this.groupId.hashCode() : 0);
        hash = hash * 31 + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        hash = hash * 31 + (this.version != null ? this.version.hashCode() : 0);
        hash = hash * 31 + (this.type != null ? this.type.hashCode() : 0);
        hash = hash * 31 + (this.classifier != null ? this.classifier.hashCode() : 0);
        return hash;
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.groupId).append(':').append(this.artifactId).append(':').append(this.type).append(':').append(this.version);
        if (this.classifier != null) {
            sb.append(':').append(this.classifier);
        }
        return sb.toString();
    }

    public static DependencyKey fromPortableString(String str) {
        int p = 0;
        int c = DependencyKey.nextColonIndex(str, p);
        String groupId = DependencyKey.substring(str, p, c);
        p = c + 1;
        c = DependencyKey.nextColonIndex(str, p);
        String artifactId = DependencyKey.substring(str, p, c);
        p = c + 1;
        c = DependencyKey.nextColonIndex(str, p);
        String type = DependencyKey.substring(str, p, c);
        p = c + 1;
        c = DependencyKey.nextColonIndex(str, p);
        String version = DependencyKey.substring(str, p, c);
        p = c + 1;
        c = DependencyKey.nextColonIndex(str, p);
        String classifier = DependencyKey.substring(str, p, c);
        return new DependencyKey(groupId, artifactId, version, classifier, type);
    }

    private static String substring(String str, int start, int end) {
        String substring = str.substring(start, end);
        return "".equals(substring) ? null : substring;
    }

    private static int nextColonIndex(String str, int pos) {
        int idx = str.indexOf(58, pos);
        if (idx < 0) {
            throw new IllegalArgumentException(NLS.bind((String)"Invalid portable string: {0}", (Object)str));
        }
        return idx;
    }

    public String toPortableString() {
        StringBuilder sb = new StringBuilder();
        if (this.groupId != null) {
            sb.append(this.groupId);
        }
        sb.append(':');
        if (this.artifactId != null) {
            sb.append(this.artifactId);
        }
        sb.append(':');
        if (this.type != null) {
            sb.append(this.type);
        }
        sb.append(':');
        if (this.version != null) {
            sb.append(this.version);
        }
        sb.append(':');
        if (this.classifier != null) {
            sb.append(this.classifier);
        }
        sb.append(':');
        return sb.toString();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }
}

