/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.adapter;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDK3Server;
import org.jboss.tools.openshift.common.core.utils.StringUtils;

public class CDK32Server
extends CDK3Server {
    public static final String PROFILE_ID = "minishift.profile";
    public static final String MINISHIFT_DEFAULT_PROFILE = "minishift";

    @Override
    protected String getBaseName() {
        return CDK32Server.getServerTypeBaseName();
    }

    public static String getServerTypeBaseName() {
        return "Container Development Environment 3.2+";
    }

    public static boolean supportsProfiles(IServer server) {
        return server.getServerType().getId().equals("org.jboss.tools.openshift.cdk.server.type.v32");
    }

    public static String[] getArgsWithProfile(IServer server, String[] args) {
        if (CDK32Server.supportsProfiles(server)) {
            String profileName = server.getAttribute(PROFILE_ID, null);
            if (StringUtils.isEmpty((String)profileName)) {
                profileName = MINISHIFT_DEFAULT_PROFILE;
            }
            if (profileName != null) {
                ArrayList<String> al = new ArrayList<String>();
                al.add("--profile");
                al.add(profileName);
                al.addAll(Arrays.asList(args));
                return al.toArray(new String[al.size()]);
            }
        }
        return args;
    }

    public static boolean matchesCDK32(String version) {
        return version.startsWith("3.") && !CDK3Server.matchesCDK3(version);
    }
}

