/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.adapter;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.jboss.ide.eclipse.as.core.util.ServerNamingUtility;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.tools.foundation.core.credentials.CredentialService;
import org.jboss.tools.foundation.core.credentials.ICredentialDomain;
import org.jboss.tools.foundation.core.credentials.UsernameChangedException;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;

public class CDKServer
extends ServerDelegate {
    public static final String CDK_SERVER_TYPE = "org.jboss.tools.openshift.cdk.server.type";
    public static final String CDK_V3_SERVER_TYPE = "org.jboss.tools.openshift.cdk.server.type.v3";
    public static final String CDK_V32_SERVER_TYPE = "org.jboss.tools.openshift.cdk.server.type.v32";
    public static final String PROP_FOLDER = "org.jboss.tools.openshift.cdk.server.core.internal.adapter.FOLDER";
    public static final String PROP_PASS_CREDENTIALS = "org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.passCredentials";
    public static final String PROP_USERNAME = "org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.username";
    public static final String PROP_USER_ENV_VAR = "org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.env.user";
    public static final String PROP_PASS_ENV_VAR = "org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.env.pass";

    public void setDefaults(IProgressMonitor monitor) {
        this.getServerWorkingCopy().setHost("localhost");
        this.setDefaultServerName(monitor);
        this.setAttribute(PROP_PASS_CREDENTIALS, true);
    }

    public void setDefaultServerName(IProgressMonitor monitor) {
        this.getServerWorkingCopy().setName(ServerNamingUtility.getDefaultServerName((String)this.getBaseName()));
    }

    protected String getBaseName() {
        return CDKServer.getServerTypeBaseName();
    }

    public static String getServerTypeBaseName() {
        return "Container Development Environment";
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        return Status.CANCEL_STATUS;
    }

    public IModule[] getChildModules(IModule[] module) {
        return new IModule[0];
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        return new IModule[0];
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
    }

    public String getUsername() {
        ControllableServerBehavior beh = (ControllableServerBehavior)this.getServer().loadAdapter(ControllableServerBehavior.class, (IProgressMonitor)new NullProgressMonitor());
        Object user2 = beh.getSharedData("CDKServerBehaviour.CACHED_USER");
        if (user2 instanceof String) {
            return (String)user2;
        }
        String user = this.getServer().getAttribute(PROP_USERNAME, null);
        if (user == null) {
            ICredentialDomain domain = CredentialService.getCredentialModel().getDomain("access.redhat.com");
            user = domain.getDefaultUsername();
        }
        return user;
    }

    public String getPassword() throws UsernameChangedException {
        ControllableServerBehavior beh = (ControllableServerBehavior)this.getServer().loadAdapter(ControllableServerBehavior.class, (IProgressMonitor)new NullProgressMonitor());
        Object pw = beh.getSharedData("CDKServerBehaviour.CACHED_PASSWORD");
        if (pw instanceof String) {
            return (String)pw;
        }
        ICredentialDomain domain = CredentialService.getCredentialModel().getDomain("access.redhat.com");
        String user = this.getUsername();
        if (user != null && domain != null) {
            try {
                return domain.getCredentials(user);
            }
            catch (StorageException se) {
                CDKCoreActivator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", se.getMessage(), (Throwable)se));
            }
            catch (UsernameChangedException uce) {
                if (uce.getSaveCredentials()) {
                    this.saveChangedCredentials(uce);
                }
                throw uce;
            }
        }
        return null;
    }

    private void saveChangedCredentials(UsernameChangedException uce) {
        IServerWorkingCopy wc = this.getServerWorkingCopy();
        if (wc == null) {
            wc = this.getServer().createWorkingCopy();
            IFile f = ((Server)this.getServer()).getFile();
            wc.setAttribute(PROP_USERNAME, uce.getUser());
            if (f == null) {
                try {
                    wc.save(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException ce) {
                    CDKCoreActivator.pluginLog().logError("Error persisting changed username", (Throwable)ce);
                }
            } else {
                final IServerWorkingCopy wc2 = wc;
                WorkspaceJob wj = new WorkspaceJob("Saving updated credentials on server " + this.getServer().getName()){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        wc2.save(true, (IProgressMonitor)new NullProgressMonitor());
                        return Status.OK_STATUS;
                    }
                };
                wj.schedule();
            }
        }
    }

    public boolean passCredentials() {
        boolean passCredentials = this.getServer().getAttribute(PROP_PASS_CREDENTIALS, false);
        return passCredentials;
    }

    public String getUserEnvironmentKey() {
        return this.getServer().getAttribute(PROP_USER_ENV_VAR, "SUB_USERNAME");
    }

    public String getPasswordEnvironmentKey() {
        return this.getServer().getAttribute(PROP_PASS_ENV_VAR, "SUB_PASSWORD");
    }
}

