/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.adapter;

import com.openshift.restclient.ClientBuilder;
import com.openshift.restclient.IClient;
import com.openshift.restclient.ISSLCertificateCallback;
import com.openshift.restclient.OpenShiftException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKConstants;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;
import org.jboss.tools.openshift.cdk.server.core.internal.VagrantBinaryUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.AbstractCDKPoller;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.OpenShiftNotReadyPollingException;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.CDKLaunchUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.CommandTimeoutException;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.CDKLaunchEnvironmentUtil;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.ServiceManagerEnvironment;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.ServiceManagerEnvironmentLoader;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.core.LazySSLCertificateCallback;

public class VagrantPoller
extends AbstractCDKPoller {
    @Override
    protected void launchThread() {
        this.launchThread("CDK Vagrant Poller");
    }

    @Override
    protected Map<String, String> createEnvironment(IServer server) {
        return CDKLaunchEnvironmentUtil.createEnvironment(server);
    }

    public int getTimeoutBehavior() {
        return 2;
    }

    private File getWorkingDirectory(IServer s) throws IServerStatePoller.PollingException {
        String str = s.getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.FOLDER", null);
        if (str != null && new File(str).exists()) {
            return new File(str);
        }
        throw new IServerStatePoller.PollingException("Working Directory not found: " + str);
    }

    @Override
    protected IStatus onePing(IServer server, Map<String, String> env) throws IServerStatePoller.PollingException, IOException, TimeoutException {
        String[] args = new String[]{"status", "--machine-readable", "--no-color"};
        String vagrantcmdloc = VagrantBinaryUtility.getVagrantLocation(server);
        try {
            String[] lines = CDKLaunchUtility.callMachineReadable(vagrantcmdloc, args, this.getWorkingDirectory(server), env);
            IStatus vmStatus = this.parseOutput(lines);
            if (vmStatus.isOK()) {
                this.checkOpenShiftHealth(server, 4000);
            }
            return vmStatus;
        }
        catch (CommandTimeoutException vte) {
            String[] asArr;
            IStatus ret;
            List<String> inLines = vte.getInLines();
            if (inLines != null && (ret = this.parseOutput(asArr = inLines.toArray(new String[inLines.size()]))) != null) {
                return ret;
            }
            CDKCoreActivator.pluginLog().logError("Unable to successfully complete a call to vagrant status. ", (Throwable)vte);
            throw vte;
        }
    }

    private boolean checkOpenShiftHealth(IServer server, int timeout) throws OpenShiftNotReadyPollingException {
        ServiceManagerEnvironment adb = ServiceManagerEnvironmentLoader.type(server).getOrLoadServiceManagerEnvironment(server, true);
        if (adb == null) {
            return false;
        }
        String url = String.valueOf(adb.getOpenShiftHost()) + ":" + adb.getOpenShiftPort();
        return this.checkOpenShiftHealth(url, timeout);
    }

    protected boolean checkOpenShiftHealth(String url, int timeout) throws OpenShiftNotReadyPollingException {
        LazySSLCertificateCallback sslCallback = new LazySSLCertificateCallback();
        IClient client = new ClientBuilder(url).sslCertificateCallback((ISSLCertificateCallback)sslCallback).withConnectTimeout(timeout, TimeUnit.MILLISECONDS).build();
        OpenShiftException e = null;
        try {
            if ("ok".equals(client.getServerReadyStatus())) {
                return true;
            }
        }
        catch (OpenShiftException ex) {
            e = ex;
        }
        String msg = NLS.bind((String)"The CDK VM is up and running, but OpenShift is unreachable at url {0}. The VM may not have been registered successfully. Please check your console output for more information", (Object)url);
        CDKCoreActivator.statusFactory();
        throw new OpenShiftNotReadyPollingException(StatusFactory.errorStatus((String)"org.jboss.tools.openshift.cdk.server.core", (String)msg, (Throwable)e, (int)10001));
    }

    protected IStatus parseOutput(String[] lines) {
        Collection<VagrantStatus> stats;
        HashMap<String, VagrantStatus> status = new HashMap<String, VagrantStatus>();
        if (lines != null && lines.length > 0) {
            int i = 0;
            while (i < lines.length) {
                String[] csv = lines[i].split(",");
                if (csv.length >= 2) {
                    String vmId = csv[1];
                    if (!StringUtils.isEmpty((String)vmId)) {
                        VagrantStatus vs = this.getVagrantStatus(status, vmId);
                        String k = csv[2];
                        String v = csv[3];
                        if (k != null) {
                            vs.setProperty(k, v);
                        }
                    } else if (csv.length >= 3 && "error-exit".equals(csv[2])) {
                        return this.createErrorStatus(csv);
                    }
                }
                ++i;
            }
        }
        if ((stats = status.values()).isEmpty()) {
            return CDKCoreActivator.statusFactory().errorStatus("Unable to retrieve vagrant status for the given CDK");
        }
        if (this.allRunning(stats)) {
            return Status.OK_STATUS;
        }
        if (this.allStopped(stats)) {
            return CDKCoreActivator.statusFactory().errorStatus("Vagrant status indicates the CDK is stopped: " + String.join((CharSequence)"\n", Arrays.asList(lines)));
        }
        CDKCoreActivator.statusFactory();
        return StatusFactory.infoStatus((String)"org.jboss.tools.openshift.cdk.server.core", (String)"Vagrant status indicates the CDK is starting.");
    }

    private VagrantStatus getVagrantStatus(Map<String, VagrantStatus> status, String vmId) {
        VagrantStatus vs = status.get(vmId);
        if (vs == null) {
            vs = new VagrantStatus(vmId);
            status.put(vmId, vs);
        }
        return vs;
    }

    private IStatus createErrorStatus(String[] csv) {
        IStatus s = null;
        s = csv.length >= 5 ? CDKCoreActivator.statusFactory().errorStatus(csv[4]) : CDKCoreActivator.statusFactory().errorStatus("An error occurred while checking CDK state.");
        CDKCoreActivator.pluginLog().logError("Unable to access CDK status via vagrant status.", (Throwable)new CoreException(s));
        return s;
    }

    private boolean allRunning(Collection<VagrantStatus> stats) {
        List<String> on = Arrays.asList(this.getValidRunningStates());
        Iterator<VagrantStatus> i = stats.iterator();
        while (i.hasNext()) {
            if (on.contains(i.next().getState())) continue;
            return false;
        }
        return true;
    }

    private String[] getValidRunningStates() {
        return new String[]{"running"};
    }

    private String[] getValidStoppedStates() {
        return new String[]{"shutoff", "poweroff", "not_created"};
    }

    private boolean allStopped(Collection<VagrantStatus> stats) {
        List<String> off = Arrays.asList(this.getValidStoppedStates());
        for (VagrantStatus tmp : stats) {
            if (off.contains(tmp.getState())) continue;
            return false;
        }
        return true;
    }

    private class VagrantStatus
    implements CDKConstants {
        private HashMap<String, String> kv;
        private String id;

        public VagrantStatus(String vmId) {
            this.id = vmId;
            this.kv = new HashMap();
        }

        public void setProperty(String k, String v) {
            this.kv.put(k, v);
        }

        public String getState() {
            return this.kv.get("state");
        }
    }
}

