/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.Server;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.util.ArgsUtil;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ILaunchServerController;
import org.jboss.tools.foundation.core.credentials.UsernameChangedException;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;
import org.jboss.tools.openshift.cdk.server.core.internal.MinishiftBinaryUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.AbstractCDKPoller;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDK32Poller;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDK32Server;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDK3Server;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.MinishiftPoller;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.AbstractCDKLaunchController;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.CDKLaunchUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.IExternalLaunchConstants;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.internal.common.core.util.CommandLocationLookupStrategy;

public class CDK3LaunchController
extends AbstractCDKLaunchController
implements ILaunchServerController,
IExternalLaunchConstants {
    @Override
    public void initialize(ILaunchConfigurationWorkingCopy wc) throws CoreException {
        IServer s = this.getServerFromLaunch(wc);
        CDKServer cdkServer = (CDKServer)((Object)s.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        this.initialize(wc, cdkServer.getUsername(), cdkServer.getServer());
    }

    public void initialize(ILaunchConfigurationWorkingCopy wc, String userName, IServer server) throws CoreException {
        wc.setAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.launch.isInitialized", true);
        String workingDir = JBossServerCorePlugin.getServerStateLocation((IServer)server).toOSString();
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", workingDir);
        CDKServer cdkServer = (CDKServer)((Object)server.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        boolean passCredentials = cdkServer.passCredentials();
        if (passCredentials) {
            HashMap<String, String> env = new HashMap<String, String>();
            String userKey = cdkServer.getUserEnvironmentKey();
            env.put(userKey, userName);
            wc.setAttribute("org.eclipse.debug.core.environmentVariables", env);
        }
        String cmdLoc = server.getAttribute("minishift.file.location", null);
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", cmdLoc);
        String profiles = CDK3LaunchController.getProfileString(server);
        String defaultArgs = String.valueOf(profiles) + "start --vm-driver=" + server.getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.hypervisor", CDK3Server.getHypervisors()[0]);
        String currentVal = wc.getAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", defaultArgs);
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", currentVal);
    }

    static String getProfileString(IServer server) {
        String profiles = String.join((CharSequence)" ", CDK32Server.getArgsWithProfile(server, new String[0]));
        if (!profiles.isEmpty()) {
            profiles = String.valueOf(profiles) + " ";
        }
        return profiles;
    }

    protected IServer getServerFromLaunch(ILaunchConfigurationWorkingCopy wc) throws CoreException {
        return ServerUtil.getServer((ILaunchConfiguration)wc);
    }

    @Override
    protected void performOverrides(ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        IServer s = this.getServerFromLaunch(workingCopy);
        CDKServer cdkServer = (CDKServer)((Object)s.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        this.performOverrides(workingCopy, s, cdkServer);
    }

    protected void performOverrides(ILaunchConfigurationWorkingCopy workingCopy, IServer s, CDKServer cdkServer) throws CoreException {
        String workingDir = JBossServerCorePlugin.getServerStateLocation((IServer)s).toOSString();
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", workingDir);
        HashMap<String, String> env = workingCopy.getAttribute("org.eclipse.debug.core.environmentVariables", null);
        env = env == null ? new HashMap<String, String>() : new HashMap(env);
        String msHome = this.getMinishiftHome(s);
        env.put("MINISHIFT_HOME", msHome);
        String userKey = cdkServer.getUserEnvironmentKey();
        boolean passCredentials = cdkServer.passCredentials();
        if (passCredentials) {
            env.put(userKey, cdkServer.getUsername());
        } else {
            env.remove(userKey);
        }
        this.setMinishiftLocationOnLaunchConfig(s, workingCopy, env);
        workingCopy.setAttribute("org.eclipse.debug.core.environmentVariables", env);
        String targetedHypervisor = s.getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.hypervisor", CDK3Server.getHypervisors()[0]);
        String profiles = CDK3LaunchController.getProfileString(s);
        String profileName = s.getAttribute("minishift.profile", null);
        String defaultArgs = String.valueOf(profiles) + "start --vm-driver=" + targetedHypervisor;
        String currentVal = workingCopy.getAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", defaultArgs);
        String replaced = ArgsUtil.setArg((String)currentVal, null, (String)"--vm-driver", (String)targetedHypervisor);
        if (!StringUtils.isEmpty((String)profileName)) {
            replaced = ArgsUtil.setArg((String)replaced, (String)"--profile", null, (String)profileName);
        }
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", replaced);
        String wcName = workingCopy.getName();
        String serverName = s.getName();
        if (!wcName.equals(serverName)) {
            workingCopy.rename(serverName);
        }
    }

    protected String getMinishiftHome(IServer server) {
        String home = System.getProperty("user.home");
        String defaultMinishiftHome = new File(home, ".minishift").getAbsolutePath();
        String msHome = server.getAttribute("minishift.home.location", defaultMinishiftHome);
        if (StringUtils.isEmpty((String)msHome)) {
            msHome = defaultMinishiftHome;
        }
        return msHome;
    }

    private void setMinishiftLocationOnLaunchConfig(IServer s, ILaunchConfigurationWorkingCopy workingCopy, Map<String, String> env) throws CoreException {
        String minishiftLoc = s.getAttribute("minishift.file.location", null);
        if (minishiftLoc == null) {
            minishiftLoc = MinishiftBinaryUtility.getMinishiftLocation((ILaunchConfiguration)workingCopy);
        }
        if (minishiftLoc != null) {
            String minishiftCmdFolder = new Path(minishiftLoc).removeLastSegments(1).toOSString();
            CommandLocationLookupStrategy.get().ensureOnPath(env, minishiftCmdFolder);
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", minishiftLoc);
        }
    }

    @Override
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IStatus stat;
        IServer s = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (s == null) {
            throw new CoreException(CDKCoreActivator.statusFactory().errorStatus("Unable to locate server from launch configuration."));
        }
        ControllableServerBehavior beh = (ControllableServerBehavior)JBossServerBehaviorUtils.getControllableBehavior((ILaunchConfiguration)configuration);
        beh.setServerStarting();
        String minishiftLoc = MinishiftBinaryUtility.getMinishiftLocation(s);
        if (minishiftLoc == null || !new File(minishiftLoc).exists()) {
            beh.setServerStopped();
            if (minishiftLoc == null) {
                throw new CoreException(CDKCoreActivator.statusFactory().errorStatus("Unable to locate minishift command. Please set a correct value in the server editor."));
            }
            throw new CoreException(CDKCoreActivator.statusFactory().errorStatus("Expected location of minishift command does not exist: " + minishiftLoc + "\nPlease set a correct value in the server editor."));
        }
        CDKServer cdkServer = (CDKServer)((Object)s.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        boolean passCredentials = cdkServer.passCredentials();
        if (passCredentials) {
            this.handleCredentialsDuringLaunch(s, cdkServer, beh);
        }
        if ((stat = this.getCDKPoller(s).getCurrentStateSynchronous(s)).isOK()) {
            beh.setServerStarted();
            ((Server)beh.getServer()).setMode("run");
            return;
        }
        String args = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", null);
        IDebugEventSetListener debug = this.getDebugListener(launch);
        DebugPlugin.getDefault().addDebugEventListener(debug);
        beh.putSharedData("AbstractStartJavaServerLaunchDelegate.DebugListener", (Object)debug);
        Process p = null;
        try {
            p = new CDKLaunchUtility().callMinishiftConsole(s, args, this.getStartupLaunchName(s));
        }
        catch (IOException ioe) {
            CDKCoreActivator.pluginLog().logError((Throwable)ioe);
            beh.setServerStopped();
            DebugPlugin.getDefault().removeDebugEventListener(debug);
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", ioe.getMessage(), (Throwable)ioe));
        }
        if (p == null) {
            beh.setServerStopped();
            DebugPlugin.getDefault().removeDebugEventListener(debug);
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", "Call to minishift up has failed."));
        }
        IProcess process = this.addProcessToLaunch(p, launch, s, false, minishiftLoc);
        beh.putSharedData("AbstractStartJavaServerLaunchDelegate.Process", (Object)process);
    }

    private void handleCredentialsDuringLaunch(IServer s, CDKServer cdkServer, ControllableServerBehavior beh) throws CoreException {
        String userKey = cdkServer.getUserEnvironmentKey();
        String passKey = cdkServer.getPasswordEnvironmentKey();
        if (userKey == null || userKey.trim().isEmpty()) {
            beh.setServerStopped();
            throw new CoreException(CDKCoreActivator.statusFactory().errorStatus("Username environment variable id cannot be empty when passing credentials via environment variables."));
        }
        if (passKey == null || passKey.trim().isEmpty()) {
            beh.setServerStopped();
            throw new CoreException(CDKCoreActivator.statusFactory().errorStatus("Password environment variable id cannot be empty when passing credentials via environment variables."));
        }
        beh.putSharedData("CDKServerBehaviour.CACHED_PASSWORD", null);
        beh.putSharedData("CDKServerBehaviour.CACHED_USER", null);
        String pass = null;
        String user = cdkServer.getUsername();
        try {
            pass = cdkServer.getPassword();
        }
        catch (UsernameChangedException uce) {
            pass = uce.getPassword();
            user = uce.getUser();
        }
        if (user == null) {
            beh.setServerStopped();
            throw new CoreException(CDKCoreActivator.statusFactory().errorStatus("The server " + s.getName() + " has no username associated with it. Please open the server editor and configure the credentials."));
        }
        if (pass == null) {
            beh.setServerStopped();
            throw new CoreException(CDKCoreActivator.statusFactory().errorStatus("The server " + s.getName() + " has no password associated with it. Please open the server editor and configure the credentials."));
        }
        beh.putSharedData("CDKServerBehaviour.CACHED_PASSWORD", (Object)pass);
        beh.putSharedData("CDKServerBehaviour.CACHED_USER", (Object)user);
    }

    @Override
    protected AbstractCDKPoller getCDKPoller(IServer server) {
        if (server.getServerType().getId().equals("org.jboss.tools.openshift.cdk.server.type.v3")) {
            return new MinishiftPoller();
        }
        return new CDK32Poller();
    }

    @Override
    protected void processTerminatedDelay() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {}
    }
}

