/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.Server;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ILaunchServerController;
import org.jboss.tools.foundation.core.credentials.UsernameChangedException;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;
import org.jboss.tools.openshift.cdk.server.core.internal.VagrantBinaryUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.AbstractCDKPoller;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.OpenShiftNotReadyPollingException;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.VagrantPoller;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.AbstractCDKLaunchController;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.CDKLaunchUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.IExternalLaunchConstants;
import org.jboss.tools.openshift.internal.common.core.util.CommandLocationLookupStrategy;

public class CDKLaunchController
extends AbstractCDKLaunchController
implements ILaunchServerController,
IExternalLaunchConstants {
    @Override
    protected void performOverrides(ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        IServer s = ServerUtil.getServer((ILaunchConfiguration)workingCopy);
        CDKServer cdkServer = (CDKServer)((Object)s.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        String workingDir = s.getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.FOLDER", null);
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", workingDir);
        HashMap<String, String> env = workingCopy.getAttribute("org.eclipse.debug.core.environmentVariables", null);
        env = env == null ? new HashMap<String, String>() : new HashMap(env);
        String userKey = cdkServer.getUserEnvironmentKey();
        boolean passCredentials = cdkServer.passCredentials();
        if (passCredentials) {
            env.put(userKey, cdkServer.getUsername());
        } else {
            env.remove(userKey);
        }
        String vLoc = VagrantBinaryUtility.getVagrantLocation((ILaunchConfiguration)workingCopy);
        if (vLoc != null) {
            String vagrantCmdFolder = new Path(vLoc).removeLastSegments(1).toOSString();
            CommandLocationLookupStrategy.get().ensureOnPath(env, vagrantCmdFolder);
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", vLoc);
        }
        if (Platform.getOS().equals("win32")) {
            env.put("VAGRANT_DETECTED_OS", "cygwin");
        }
        workingCopy.setAttribute("org.eclipse.debug.core.environmentVariables", env);
    }

    @Override
    public void initialize(ILaunchConfigurationWorkingCopy wc) throws CoreException {
        IServer s = ServerUtil.getServer((ILaunchConfiguration)wc);
        CDKServer cdkServer = (CDKServer)((Object)s.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        this.initialize(wc, cdkServer.getUsername(), cdkServer.getServer());
    }

    public void initialize(ILaunchConfigurationWorkingCopy wc, String userName, IServer server) throws CoreException {
        wc.setAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.launch.isInitialized", true);
        String workingDir = server.getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.FOLDER", null);
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", workingDir);
        CDKServer cdkServer = (CDKServer)((Object)server.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        boolean passCredentials = cdkServer.passCredentials();
        if (passCredentials) {
            HashMap<String, String> env = new HashMap<String, String>();
            String userKey = cdkServer.getUserEnvironmentKey();
            env.put(userKey, userName);
            wc.setAttribute("org.eclipse.debug.core.environmentVariables", env);
        }
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", VagrantBinaryUtility.getVagrantLocation());
        String args = "up --no-color";
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", args);
    }

    @Override
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IStatus stat;
        IServer s = ServerUtil.getServer((ILaunchConfiguration)configuration);
        this.verifyServer(s);
        ControllableServerBehavior beh = (ControllableServerBehavior)JBossServerBehaviorUtils.getControllableBehavior((ILaunchConfiguration)configuration);
        beh.setServerStarting();
        String vagrantLoc = VagrantBinaryUtility.getVagrantLocation(s);
        if (vagrantLoc == null || !new File(vagrantLoc).exists()) {
            beh.setServerStopped();
            if (vagrantLoc == null) {
                throw new CoreException(CDKCoreActivator.statusFactory().errorStatus("Unable to locate vagrant command. Please check the server's launch configuration on the 'Environment' tab to ensure that the command is available on your Path environment variable."));
            }
            throw new CoreException(CDKCoreActivator.statusFactory().errorStatus("Expected location of vagrant command does not exist: " + vagrantLoc));
        }
        CDKServer cdkServer = (CDKServer)((Object)s.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        boolean passCredentials = cdkServer.passCredentials();
        if (passCredentials) {
            this.setBehaviourUserAndPassword(s, beh, cdkServer);
        }
        if ((stat = this.getCDKPoller(s).getCurrentStateSynchronous(s)).isOK()) {
            beh.setServerStarted();
            ((Server)beh.getServer()).setMode("run");
            return;
        }
        String args = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", null);
        Process p = this.getProcess(s, beh, args);
        if (p == null) {
            beh.setServerStopped();
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", "Call to vagrant up has failed."));
        }
        IProcess process = this.addProcessToLaunch(p, launch, s, true);
        IDebugEventSetListener debug = this.getDebugListener(new IProcess[]{process}, launch);
        DebugPlugin.getDefault().addDebugEventListener(debug);
        beh.putSharedData("AbstractStartJavaServerLaunchDelegate.Process", (Object)process);
        beh.putSharedData("AbstractStartJavaServerLaunchDelegate.DebugListener", (Object)debug);
    }

    private void verifyServer(IServer s) throws CoreException {
        if (s == null) {
            throw new CoreException(CDKCoreActivator.statusFactory().errorStatus("Unable to locate server from launch configuration."));
        }
    }

    private void setBehaviourUserAndPassword(IServer s, ControllableServerBehavior beh, CDKServer cdkServer) throws CoreException {
        this.verifyUser(beh, cdkServer.getUserEnvironmentKey());
        this.verifyPassword(beh, cdkServer.getPasswordEnvironmentKey());
        String pass = null;
        String user = cdkServer.getUsername();
        try {
            pass = cdkServer.getPassword();
        }
        catch (UsernameChangedException uce) {
            pass = uce.getPassword();
            user = uce.getUser();
        }
        if (user == null) {
            beh.setServerStopped();
            throw new CoreException(CDKCoreActivator.statusFactory().errorStatus("The server " + s.getName() + " has no username associated with it. Please open the server editor and configure the credentials."));
        }
        if (pass == null) {
            beh.setServerStopped();
            throw new CoreException(CDKCoreActivator.statusFactory().errorStatus("The server " + s.getName() + " has no password associated with it. Please open the server editor and configure the credentials."));
        }
        beh.putSharedData("CDKServerBehaviour.CACHED_PASSWORD", (Object)pass);
        beh.putSharedData("CDKServerBehaviour.CACHED_USER", (Object)user);
    }

    private Process getProcess(IServer s, ControllableServerBehavior beh, String args) throws CoreException {
        try {
            return new CDKLaunchUtility().callInteractive(s, args, this.getStartupLaunchName(s));
        }
        catch (IOException ioe) {
            CDKCoreActivator.pluginLog().logError((Throwable)ioe);
            beh.setServerStopped();
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", ioe.getMessage(), (Throwable)ioe));
        }
    }

    private void verifyPassword(ControllableServerBehavior beh, String passKey) throws CoreException {
        if (passKey == null || passKey.trim().isEmpty()) {
            beh.setServerStopped();
            throw new CoreException(CDKCoreActivator.statusFactory().errorStatus("Password environment variable id cannot be empty when passing credentials via environment variables."));
        }
    }

    private void verifyUser(ControllableServerBehavior beh, String userKey) throws CoreException {
        if (userKey == null || userKey.trim().isEmpty()) {
            beh.setServerStopped();
            throw new CoreException(CDKCoreActivator.statusFactory().errorStatus("Username environment variable id cannot be empty when passing credentials via environment variables."));
        }
    }

    private void verifyVagrantLocation(ControllableServerBehavior beh, String vagrantLoc) throws CoreException {
        if (vagrantLoc == null) {
            beh.setServerStopped();
            throw new CoreException(CDKCoreActivator.statusFactory().errorStatus("Unable to locate vagrant command. Please check to ensure that the command is available on your Path environment variable."));
        }
        if (!new File(vagrantLoc).exists()) {
            throw new CoreException(CDKCoreActivator.statusFactory().errorStatus("Expected location of vagrant command does not exist: " + vagrantLoc));
        }
    }

    @Override
    protected LaunchManager getLaunchManager() {
        return (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
    }

    @Override
    protected AbstractCDKPoller getCDKPoller(IServer server) {
        return new VagrantPoller();
    }

    @Override
    protected void processTerminatedDelay() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void handleOpenShiftUnavailable(IControllableServerBehavior beh, final OpenShiftNotReadyPollingException osnrpe) {
        ((ControllableServerBehavior)beh).setServerStarted();
        ((Server)beh.getServer()).setMode("run");
        new Job(osnrpe.getMessage()){

            protected IStatus run(IProgressMonitor monitor) {
                return CDKCoreActivator.statusFactory().errorStatus("Error contacting OpenShift", (Throwable)((Object)osnrpe));
            }
        }.schedule();
    }
}

