/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.listeners;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public class ServiceManagerEnvironment {
    public static final String SHARED_INFO_KEY = "cdk.sharedinfo.serviceManagerEnvironment";
    public static final String KEY_DOCKER_HOST = "DOCKER_HOST";
    public static final String KEY_DOCKER_TLS_VERIFY = "DOCKER_TLS_VERIFY";
    public static final String KEY_DOCKER_CERT_PATH = "DOCKER_CERT_PATH";
    public static final String KEY_DOCKER_API_VERSION = "DOCKER_API_VERSION";
    public static final String IMAGE_REGISTRY_KEY = "DOCKER_REGISTRY";
    public static final String KEY_DEFAULT_IMAGE_REGISTRY = "jbt.default.DOCKER_REGISTRY";
    public static final String KEY_OPENSHIFT_HOST = "HOST";
    public static final String KEY_OPENSHIFT_PORT = "PORT";
    public static final String KEY_OPENSHIFT_CONSOLE_URL = "CONSOLE_URL";
    private static final String DOTCDK_AUTH_SCHEME = "openshift.auth.scheme";
    private static final String DOTCDK_AUTH_USERNAME = "openshift.auth.username";
    private static final String DOTCDK_AUTH_PASS = "openshift.auth.password";
    private static final String HTTPS_SCHEMA = "https://";
    int openshiftPort = 8443;
    String openshiftHost = "https://10.1.2.2";
    private Map<String, String> env;

    public ServiceManagerEnvironment(Map<String, String> env) throws URISyntaxException {
        String dockerHost;
        String osHost;
        this.env = env;
        String osPort = env.get(KEY_OPENSHIFT_PORT);
        if (osPort != null) {
            try {
                this.openshiftPort = Integer.parseInt(osPort);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((osHost = env.get(KEY_OPENSHIFT_HOST)) == null && (dockerHost = env.get(KEY_DOCKER_HOST)) != null) {
            URI url = new URI(dockerHost);
            osHost = url.getHost();
        }
        if (osHost != null) {
            this.openshiftHost = HTTPS_SCHEMA + osHost;
        }
    }

    public String getOpenShiftHost() {
        return this.openshiftHost;
    }

    public int getOpenShiftPort() {
        return this.openshiftPort;
    }

    public String getDockerRegistry() {
        String dockerReg = this.env.get(IMAGE_REGISTRY_KEY);
        if (dockerReg == null) {
            dockerReg = this.env.get(KEY_DEFAULT_IMAGE_REGISTRY);
        }
        if (dockerReg != null && !dockerReg.contains("://")) {
            dockerReg = HTTPS_SCHEMA + dockerReg;
        }
        return dockerReg;
    }

    public String getAuthorizationScheme() {
        String authScheme = this.env.containsKey(DOTCDK_AUTH_SCHEME) ? this.env.get(DOTCDK_AUTH_SCHEME) : "Basic";
        return authScheme;
    }

    public String getUsername() {
        String user = this.env.containsKey(DOTCDK_AUTH_USERNAME) ? this.env.get(DOTCDK_AUTH_USERNAME) : "openshift-dev";
        return user;
    }

    public String getPassword() {
        String user = this.getUsername();
        String defPass = "openshift-dev".equals(user) ? "devel" : null;
        String pass = this.env.containsKey(DOTCDK_AUTH_PASS) ? this.env.get(DOTCDK_AUTH_PASS) : defPass;
        return pass;
    }

    public String getDockerHost() {
        return this.env.get(KEY_DOCKER_HOST);
    }

    public String getDockerTLSVerify() {
        return this.env.get(KEY_DOCKER_TLS_VERIFY);
    }

    public String getDockerCertPath() {
        return this.env.get(KEY_DOCKER_CERT_PATH);
    }

    public String get(String k) {
        return this.env.get(k);
    }
}

