/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.common.core.connection;

import java.util.Objects;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.common.core.utils.UrlUtils;

public abstract class AbstractConnection
extends ObservablePojo
implements IConnection {
    private String host;

    protected AbstractConnection(String host) {
        this(null, host);
    }

    protected AbstractConnection(String scheme, String host) {
        this.host = this.getHost(scheme, host);
    }

    private String getHost(String scheme, String host) {
        if (StringUtils.isEmpty(host)) {
            return host;
        }
        if (StringUtils.isEmpty(scheme)) {
            scheme = "https://";
        }
        return UrlUtils.ensureStartsWithScheme(host, scheme);
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getScheme() {
        return UrlUtils.getScheme(this.host);
    }

    @Override
    public abstract boolean connect();

    public abstract boolean isConnected();

    @Override
    public abstract IConnection clone();

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractConnection)) {
            return false;
        }
        AbstractConnection other = (AbstractConnection)obj;
        if (!Objects.equals(this.host, other.host)) {
            return false;
        }
        return Objects.equals(this.getUsername(), other.getUsername());
    }

    @Override
    public boolean credentialsEqual(IConnection connection) {
        if (!this.equals(connection)) {
            return false;
        }
        AbstractConnection other = (AbstractConnection)connection;
        return Objects.equals(this.getPassword(), other.getPassword());
    }
}

