/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.common.core.connection;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.common.core.connection.ConnectionURL;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.utils.UrlUtils;

public abstract class AbstractConnectionPersistency<C extends IConnection> {
    public Collection<C> load() {
        String[] persistedConnections;
        HashMap connections = new HashMap();
        String[] stringArray = persistedConnections = this.loadPersisted();
        int n = persistedConnections.length;
        int n2 = 0;
        while (n2 < n) {
            String connectionUrl = stringArray[n2];
            this.addConnection((C)connectionUrl, (Map<String, C>)connections);
            ++n2;
        }
        return new ArrayList(connections.values());
    }

    private void addConnection(String connectionUrl, Map<String, C> connections) {
        try {
            C connection = this.createConnection(this.createConnectionURL(connectionUrl));
            if (connection != null) {
                connections.put(connectionUrl, connection);
            }
        }
        catch (MalformedURLException e) {
            this.logError(NLS.bind((String)"Could not add connection for {0}.", (Object)connectionUrl), e);
        }
        catch (UnsupportedEncodingException e) {
            this.logError(NLS.bind((String)"Could not add connection for {0}.", (Object)connectionUrl), e);
        }
        catch (IllegalArgumentException e) {
            this.logError(NLS.bind((String)"Could not add connection for {0}.", (Object)connectionUrl), e);
        }
    }

    private ConnectionURL createConnectionURL(String connectionUrl) throws UnsupportedEncodingException, MalformedURLException {
        if (UrlUtils.hasScheme(connectionUrl)) {
            return ConnectionURL.forURL(connectionUrl);
        }
        return ConnectionURL.forUsername(connectionUrl);
    }

    public void save(Collection<C> connections) {
        if (connections == null) {
            return;
        }
        HashMap serializedConnections = new HashMap(connections.size());
        for (IConnection connection : connections) {
            this.addConnection(connection, serializedConnections);
        }
        this.persist(serializedConnections);
    }

    private void addConnection(C connection, Map<String, C> serializedConnections) {
        try {
            ConnectionURL connectionURL = ConnectionURL.forConnection(connection);
            serializedConnections.put(connectionURL.toString(), connection);
        }
        catch (MalformedURLException e) {
            this.logError(NLS.bind((String)"Could not add connection for {0}@{1}.", (Object)connection.getUsername(), (Object)connection.getHost()), e);
        }
        catch (UnsupportedEncodingException e) {
            this.logError(NLS.bind((String)"Could not add connection for {0}@{1}.", (Object)connection.getUsername(), (Object)connection.getHost()), e);
        }
    }

    protected abstract String[] loadPersisted();

    protected abstract void persist(Map<String, C> var1);

    protected abstract void logError(String var1, Exception var2);

    protected abstract C createConnection(ConnectionURL var1);
}

