/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.common.core.connection;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import org.eclipse.core.runtime.Assert;
import org.jboss.tools.openshift.common.core.utils.StringUtils;

public class HumanReadableX509Certificate {
    public static final String PRINCIPAL_COMMON_NAME = "CN";
    public static final String PRINCIPAL_ORGANISATIONAL_UNIT = "OU";
    public static final String PRINCIPAL_ORGANISATION = "O";
    public static final String PRINCIPAL_LOCALITY = "L";
    public static final String PRINCIPAL_STATE = "ST";
    public static final String PRINCIPAL_COUNTRY = "C";
    public static final String LABEL_PRINCIPAL_COMMON_NAME = "Common Name (CN)";
    public static final String LABEL_PRINCIPAL_ORGANISATIONAL_UNIT = "Organisational Unit (OU)";
    public static final String LABEL_PRINCIPAL_ORGANISATION = "Organisation (O)";
    public static final String LABEL_PRINCIPAL_LOCALITY = "Locality (L)";
    public static final String LABEL_PRINCIPAL_STATE = "State (ST)";
    public static final String LABEL_PRINCIPAL_COUNTRY = "Country (C)";
    private static final String DATE_FORMAT = "E, d MMM yyyy HH:mm:ss z";
    public static final String LABEL_VALIDITY_ISSUED_ON = "Issued On ";
    public static final String LABEL_VALIDITY_EXPIRES_ON = "Expires On ";
    public static final String SEPARATOR_LABEL_VALUE = ": ";
    private static final String HEX_CHARS = "0123456789ABCDEF";
    private String validity;
    private String fingerprint;
    private X509Certificate certificate;

    public HumanReadableX509Certificate(X509Certificate certificate) {
        Assert.isLegal((certificate != null ? 1 : 0) != 0);
        this.validity = this.getValidity(certificate);
        this.fingerprint = this.getFingerprint(certificate);
        this.certificate = certificate;
    }

    public String getValidity() {
        return this.validity;
    }

    public String getIssuedBy() {
        return this.getAllRDN(this.certificate.getIssuerX500Principal());
    }

    public String getIssuedBy(String name) {
        return this.getRDNValue(name, this.certificate.getIssuerX500Principal());
    }

    public String getIssuedTo() {
        return this.getAllRDN(this.certificate.getSubjectX500Principal());
    }

    public String getIssuedTo(String name) {
        return this.getRDNValue(name, this.certificate.getSubjectX500Principal());
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    private String getRDNValue(String type, X500Principal principal) {
        if (StringUtils.isEmpty(type)) {
            return this.getAllRDN(principal);
        }
        try {
            LdapName ldapName = new LdapName(principal.getName());
            for (Rdn rdn : ldapName.getRdns()) {
                if (!type.equals(rdn.getType())) continue;
                return StringUtils.toStringOrNull(rdn.getValue());
            }
            return null;
        }
        catch (InvalidNameException invalidNameException) {
            return null;
        }
    }

    private String getAllRDN(X500Principal principal) {
        StringBuilder builder = new StringBuilder();
        try {
            LdapName ldapDN = new LdapName(principal.getName());
            int i = 0;
            for (Rdn rdn : ldapDN.getRdns()) {
                String type = this.getTypeFullName(rdn.getType());
                if (StringUtils.isEmpty(type)) continue;
                if (i++ > 0) {
                    builder.append(StringUtils.getLineSeparator());
                }
                builder.append(type).append(SEPARATOR_LABEL_VALUE).append(StringUtils.toStringOrNull(rdn.getValue()));
            }
            return builder.toString();
        }
        catch (InvalidNameException invalidNameException) {
            return builder.toString();
        }
    }

    private String getValidity(X509Certificate certificate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.ENGLISH);
        return LABEL_VALIDITY_ISSUED_ON + SEPARATOR_LABEL_VALUE + dateFormat.format(certificate.getNotBefore()) + StringUtils.getLineSeparator() + LABEL_VALIDITY_EXPIRES_ON + SEPARATOR_LABEL_VALUE + dateFormat.format(certificate.getNotAfter());
    }

    private String getFingerprint(X509Certificate certificate) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            sha1.update(certificate.getEncoded());
            return this.toHexString(sha1.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "<Could not determine fingerprint>";
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return "<Could not determine fingerprint>";
        }
    }

    private String toHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2 + 0] = HEX_CHARS.charAt((v & 0xF0) >> 4);
            hexChars[j * 2 + 1] = HEX_CHARS.charAt(v & 0xF);
            ++j;
        }
        return new String(hexChars);
    }

    private String getTypeFullName(String type) {
        switch (type) {
            case "C": {
                return LABEL_PRINCIPAL_COUNTRY;
            }
            case "ST": {
                return LABEL_PRINCIPAL_STATE;
            }
            case "L": {
                return LABEL_PRINCIPAL_LOCALITY;
            }
            case "O": {
                return LABEL_PRINCIPAL_ORGANISATION;
            }
            case "OU": {
                return LABEL_PRINCIPAL_ORGANISATIONAL_UNIT;
            }
            case "CN": {
                return LABEL_PRINCIPAL_COMMON_NAME;
            }
        }
        return null;
    }
}

