/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.common.core.server;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.util.ServerUtil;
import org.jboss.tools.openshift.common.core.utils.ProjectUtils;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.internal.common.core.OpenShiftCommonCoreActivator;
import org.osgi.service.prefs.BackingStoreException;

public class ServerUtils {
    public static String getServerName(String baseName) {
        return ServerUtil.getDefaultServerName((String)baseName);
    }

    public static String getProjectAttribute(String name, String defaultValue, String nodeQualifier, IProject project) {
        if (!ProjectUtils.isAccessible(project) || StringUtils.isEmpty(nodeQualifier)) {
            return defaultValue;
        }
        IEclipsePreferences node = ServerUtils.getProjectNode(nodeQualifier, project);
        if (node == null) {
            return defaultValue;
        }
        return node.get(name, defaultValue);
    }

    public static IEclipsePreferences getProjectNode(String nodeQualifier, IProject project) {
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode(nodeQualifier);
        return node;
    }

    public static void setProjectAttribute(String name, String value, String nodeQualifier, IProject project) {
        ServerUtils.setProjectAttribute(name, value, nodeQualifier, project, false);
    }

    public static void setProjectAttribute(String name, String value, String nodeQualifier, IProject project, boolean flush) {
        IEclipsePreferences node = ServerUtils.getProjectNode(nodeQualifier, project);
        node.put(name, value);
        if (flush) {
            try {
                node.flush();
            }
            catch (BackingStoreException bse) {
                OpenShiftCommonCoreActivator.pluginLog().logError("Error saving project setting", (Throwable)bse);
            }
        }
    }

    public static String getServerAttribute(String name, String defaultValue, IServerAttributes attributes) {
        if (attributes == null) {
            return null;
        }
        return attributes.getAttribute(name, defaultValue);
    }

    public static IContainer getContainer(String name, IProject project) {
        if (!StringUtils.isEmpty(name)) {
            return (IContainer)project.findMember((IPath)new Path(name));
        }
        return project;
    }
}

