/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.core.job;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class JobChainBuilder {
    private Job job;
    private IProgressMonitor progressMonitor;

    public JobChainBuilder(Job job) {
        this(job, (IProgressMonitor)new NullProgressMonitor());
    }

    public JobChainBuilder(Job job, IProgressMonitor progressMonitor) {
        this.job = job;
        this.setProgressMonitor(progressMonitor);
    }

    public JobChainBuilder setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor == null ? new NullProgressMonitor() : progressMonitor;
        return this;
    }

    public JobChainBuilder runWhenDoneIf(final ISchedulingCondition condition, final Job constrainedJob) {
        this.job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!JobChainBuilder.this.progressMonitor.isCanceled() && (condition == null || condition.isFullfilled(JobChainBuilder.this.job))) {
                    constrainedJob.schedule();
                }
            }
        });
        return new JobConstraint(constrainedJob, this);
    }

    public JobChainBuilder runWhenDone(Job constrainedJob) {
        return this.runWhenDoneIf(new NullCondition(), constrainedJob);
    }

    public JobChainBuilder runWhenSuccessfullyDone(Job constrainedJob) {
        return this.runWhenDoneIf(new SuccessfullyDoneCondition(), constrainedJob);
    }

    public Job build() {
        return this.job;
    }

    public void schedule() {
        if (!this.progressMonitor.isCanceled()) {
            this.job.schedule();
        }
    }

    public void cancel() {
        this.progressMonitor.setCanceled(true);
    }

    public static interface ISchedulingCondition {
        public boolean isFullfilled(Job var1);
    }

    public class JobConstraint
    extends JobChainBuilder {
        private JobChainBuilder builder;

        private JobConstraint(Job job, JobChainBuilder builder) {
            super(job, builder.progressMonitor);
            this.builder = builder;
        }

        @Override
        public Job build() {
            return this.builder.build();
        }

        @Override
        public void schedule() {
            this.builder.schedule();
        }
    }

    public static class NullCondition
    implements ISchedulingCondition {
        @Override
        public boolean isFullfilled(Job preceedingJob) {
            return true;
        }
    }

    public static class SuccessfullyDoneCondition
    implements ISchedulingCondition {
        @Override
        public boolean isFullfilled(Job preceedingJob) {
            return preceedingJob != null && preceedingJob.getResult() != null && preceedingJob.getResult().isOK();
        }
    }
}

