/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.core.preferences;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jboss.tools.openshift.internal.common.core.preferences.AbstractPreferenceValue;

public class StringsPreferenceValue
extends AbstractPreferenceValue<String[]> {
    private static final int NO_MAXSIZE = -1;
    private String delimiter;
    private String escapedDelimiter;
    private int maxSize;

    public StringsPreferenceValue(char delimiter, String prefsKey, String pluginId) {
        this(delimiter, -1, prefsKey, pluginId);
    }

    public StringsPreferenceValue(char delimiter, int maxSize, String prefsKey, String pluginId) {
        super(prefsKey, pluginId);
        this.delimiter = String.valueOf(delimiter);
        this.maxSize = maxSize;
        try {
            this.escapedDelimiter = URLEncoder.encode(String.valueOf(delimiter), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    @Override
    public String[] get() {
        return this.split(this.doGet());
    }

    private String[] split(String string) {
        ArrayList<String> values = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(string, this.delimiter);
        while (tokenizer.hasMoreTokens()) {
            String value = tokenizer.nextToken();
            String unescapedValue = this.unescapeDelimiterCharacter(value);
            values.add(unescapedValue);
        }
        return values.toArray(new String[values.size()]);
    }

    public void add(String value) {
        String currentValues = this.doGet();
        if (!this.isContained(value = this.escapeDelimiterCharacter(value), currentValues)) {
            StringBuilder builder = new StringBuilder(currentValues);
            if (!this.isEmpty(currentValues)) {
                String[] values = this.split(currentValues);
                if (this.maxSize != -1 && values.length >= this.maxSize) {
                    values = this.shiftLeft(value, values);
                    values[this.maxSize - 1] = value;
                    builder = new StringBuilder(this.concatenate(values));
                } else {
                    builder.append(this.delimiter).append(value);
                }
            } else {
                builder.append(value);
            }
            this.doStore(builder.toString());
        }
    }

    protected String[] shiftLeft(String value, String[] values) {
        String[] copy = new String[this.maxSize];
        System.arraycopy(values, 1, copy, 0, this.maxSize - 1);
        return copy;
    }

    protected String escapeDelimiterCharacter(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        int index = value.indexOf(this.delimiter);
        if (index < 0) {
            return value;
        }
        StringBuilder builder = new StringBuilder(value.substring(0, index));
        builder.append(this.escapedDelimiter);
        builder.append(value.substring(index + 1));
        return builder.toString();
    }

    protected String unescapeDelimiterCharacter(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        int index = value.indexOf(this.escapedDelimiter);
        if (index < 0) {
            return value;
        }
        StringBuilder builder = new StringBuilder(value.substring(0, index));
        builder.append(this.delimiter);
        builder.append(value.substring(index + 1));
        return builder.toString();
    }

    protected boolean isContained(String value, String currentValues) {
        return currentValues != null && currentValues.length() > 0 && currentValues.indexOf(value) >= 0;
    }

    protected boolean isEmpty(String currentValues) {
        return currentValues == null || currentValues.length() == 0;
    }

    public void remove(String ... valuesToRemove) {
        boolean removed = false;
        String[] currentValues = this.get();
        if (valuesToRemove != null) {
            int i = 0;
            while (i < currentValues.length) {
                String[] stringArray = valuesToRemove;
                int n = valuesToRemove.length;
                int n2 = 0;
                while (n2 < n) {
                    String valueToRemove = stringArray[n2];
                    if (valueToRemove.equals(currentValues[i])) {
                        currentValues[i] = null;
                        removed = true;
                    }
                    ++n2;
                }
                ++i;
            }
        }
        if (removed) {
            this.doStore(this.concatenate(currentValues));
        }
    }

    protected String concatenate(String[] values) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < values.length) {
            if (values[i] != null) {
                if (builder.length() > 0) {
                    builder.append(this.delimiter);
                }
                builder.append(values[i]);
            }
            ++i;
        }
        return builder.toString();
    }

    @Override
    public void set(String[] values) {
        this.doStore(this.concatenate(values));
    }

    public int size() {
        return this.get().length;
    }
}

