/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.core.security;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.internal.common.core.security.SecureStoreException;

public class SecureStore {
    private Map<String, String> values;
    private IStoreKey storeKey;

    public SecureStore(IStoreKey key) {
        this.storeKey = key;
        this.values = new HashMap<String, String>();
    }

    public String get(String id) throws SecureStoreException {
        try {
            String value = this.get(id, this.storeKey);
            this.values.put(id, value);
            return value;
        }
        catch (Exception e) {
            throw new SecureStoreException(NLS.bind((String)"Could not get value {0}", (Object)id), e);
        }
    }

    public void put(String id, String value) throws SecureStoreException {
        if (this.isValueChanged(id, value)) {
            this.store(id, value, this.storeKey);
        }
    }

    private boolean isValueChanged(String id, String value) {
        String cachedValue = this.values.get(id);
        if (cachedValue == null) {
            return value != null;
        }
        return !cachedValue.equals(value);
    }

    public void remove(String id) throws SecureStoreException {
        try {
            this.getNode(this.storeKey).remove(id);
            this.values.remove(id);
        }
        catch (Exception e) {
            throw new SecureStoreException(NLS.bind((String)"Could not remove value {0}", (Object)id), e);
        }
    }

    public void clear() throws SecureStoreException {
        try {
            this.getNode(this.storeKey).clear();
            this.values.clear();
        }
        catch (Exception e) {
            throw new SecureStoreException(NLS.bind((String)"Could not clear storage node {0}", (Object)this.storeKey.getKey()), e);
        }
    }

    public void removeNode() throws SecureStoreException {
        try {
            this.getNode(this.storeKey).removeNode();
        }
        catch (UnsupportedEncodingException | SecureStoreException e) {
            throw new SecureStoreException(NLS.bind((String)"Could not remove storage node {0}", (Object)this.storeKey.getKey()), e);
        }
    }

    private String get(String id, IStoreKey key) throws StorageException, UnsupportedEncodingException, SecureStoreException {
        if (StringUtils.isEmpty((String)id) || key == null) {
            return null;
        }
        String value = this.getNode(key).get(id, null);
        if (value == null) {
            return null;
        }
        return new String(EncodingUtils.decodeBase64((String)value));
    }

    private void store(String id, String value, IStoreKey key) throws SecureStoreException {
        try {
            this.getNode(this.storeKey).put(id, EncodingUtils.encodeBase64((byte[])value.getBytes()), true);
        }
        catch (Exception e) {
            throw new SecureStoreException(NLS.bind((String)"Could not store value {0}: {1}", (Object)id, (Object)value), e);
        }
    }

    private ISecurePreferences getNode(IStoreKey key) throws UnsupportedEncodingException, SecureStoreException {
        if (key == null) {
            throw new SecureStoreException("storage key is null.");
        }
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        ISecurePreferences node = root.node(key.getKey());
        if (node == null) {
            throw new SecureStoreException(NLS.bind((String)"Could find storage node {0}", (Object)key.getKey()));
        }
        return node;
    }

    public static interface IStoreKey {
        public String getKey();
    }
}

