/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.core.util;

import java.util.HashMap;
import org.jboss.tools.openshift.internal.common.core.util.CommandLocationLookupStrategy;

public class CommandLocationBinary {
    private HashMap<String, String> commandMap = new HashMap();
    private HashMap<String, String> defaultLocMap = new HashMap();
    private String defaultPlatform;
    private String commandName;
    private String foundLoc = null;
    private boolean searchFailed = false;

    public CommandLocationBinary(String commandName) {
        this.commandName = commandName;
    }

    public void addPlatformLocation(String platform, String loc) {
        this.defaultLocMap.put(platform, loc);
    }

    public void addPlatformCommandName(String platform, String command) {
        this.commandMap.put(platform, command);
    }

    public void setDefaultPlatform(String platform) {
        this.defaultPlatform = platform;
    }

    public String getCommand(String platform) {
        return this.commandMap.containsKey(platform) ? this.commandMap.get(platform) : this.commandName;
    }

    public String getDefaultLoc(String platform) {
        return this.defaultLocMap.containsKey(platform) ? this.defaultLocMap.get(platform) : this.defaultLocMap.get(this.defaultPlatform);
    }

    public String findLocation() {
        return this.findLocation(2000);
    }

    public String findLocation(int timeout) {
        if (this.foundLoc != null || this.searchFailed) {
            return this.foundLoc;
        }
        String searched = CommandLocationLookupStrategy.get().search(this, timeout);
        if (searched == null) {
            this.searchFailed = true;
        }
        this.foundLoc = searched;
        return searched;
    }

    public String[] getPossibleSuffixes() {
        return CommandLocationLookupStrategy.get().getSuffixes();
    }
}

