/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class ImageRepository {
    private ImageRegistry imageRegistry;
    private URL baseUrl;
    private Plugin plugin;
    private String imageFolder;

    public ImageRepository(String imageFolder, Plugin plugin, ImageRegistry imageRegistry) {
        this.imageFolder = imageFolder;
        this.plugin = plugin;
        this.imageRegistry = imageRegistry;
    }

    protected URL getBaseUrl() {
        try {
            if (this.baseUrl == null) {
                this.baseUrl = new URL(this.plugin.getBundle().getEntry("/"), this.imageFolder);
            }
            return this.baseUrl;
        }
        catch (MalformedURLException e) {
            this.plugin.getLog().log((IStatus)new Status(4, this.plugin.getBundle().getSymbolicName(), NLS.bind((String)"Could not find image folder at {0}", (Object)this.imageFolder), (Throwable)e));
            return null;
        }
    }

    public ImageDescriptor create(String name) {
        return this.create(this.imageRegistry, name);
    }

    private ImageDescriptor create(ImageRegistry registry, String name) {
        return this.create(registry, name, this.getBaseUrl());
    }

    private ImageDescriptor create(ImageRegistry registry, String name, URL baseUrl) {
        if (baseUrl == null) {
            return null;
        }
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)this.createFileURL(name, baseUrl));
        registry.put(name, imageDescriptor);
        return imageDescriptor;
    }

    private URL createFileURL(String name, URL baseUrl) {
        try {
            return new URL(baseUrl, name);
        }
        catch (MalformedURLException e) {
            this.plugin.getLog().log((IStatus)new Status(4, this.plugin.getBundle().getSymbolicName(), NLS.bind((String)"Could not create URL for image {0}", (Object)name), (Throwable)e));
            return null;
        }
    }

    public Image getImage(String name) {
        return this.imageRegistry.get(name);
    }
}

