/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.utils.ProjectUtils;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;

public class SelectProjectComponentBuilder {
    String textLabel = "Use existing workspace project:";
    String browseLabel = "Browse...";
    String errorText = "Select an existing project";
    int hSpan = 1;
    boolean required = true;
    IObservableValue<?> eclipseProjectObservable;
    SelectionListener selectionListener;
    ISWTObservableValue projectNameTextObservable;

    public void build(Composite container, DataBindingContext dbc) {
        Label existingProjectLabel = new Label(container, 0);
        existingProjectLabel.setText("Eclipse Project: ");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)existingProjectLabel);
        final Text existingProjectNameText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(this.hSpan, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)existingProjectNameText);
        this.projectNameTextObservable = WidgetProperties.text((int)24).observe((Widget)existingProjectNameText);
        Binding eclipseProjectBinding = ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)this.projectNameTextObservable).validatingAfterConvert(new IValidator(){

            public IStatus validate(Object value) {
                if (value instanceof String) {
                    return ValidationStatus.ok();
                }
                if (value == null) {
                    if (SelectProjectComponentBuilder.this.required) {
                        return ValidationStatus.error((String)"Select an existing project");
                    }
                    if (!StringUtils.isEmpty((String)existingProjectNameText.getText())) {
                        return ValidationStatus.error((String)NLS.bind((String)"Project {0} does not exist", (Object)existingProjectNameText.getText()));
                    }
                }
                return ValidationStatus.ok();
            }
        })).converting((IConverter)new Converter(String.class, IProject.class){

            public Object convert(Object fromObject) {
                String name = (String)fromObject;
                return ProjectUtils.getProject((String)name);
            }
        })).to(this.eclipseProjectObservable).converting((IConverter)new Converter(IProject.class, String.class){

            public Object convert(Object fromObject) {
                return fromObject == null ? "" : ((IProject)fromObject).getName();
            }
        })).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)eclipseProjectBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        ControlDecoration dec = new ControlDecoration((Control)existingProjectNameText, 131200);
        FieldDecoration contentProposalFieldIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        dec.setImage(contentProposalFieldIndicator.getImage());
        dec.setDescriptionText("Auto-completion is enabled when you start typing a project name.");
        dec.setShowOnlyOnFocus(true);
        new AutoCompleteField((Control)existingProjectNameText, (IControlContentAdapter)new TextContentAdapter(), ProjectUtils.getAllAccessibleProjectNames());
        Button browseProjectsButton = new Button(container, 0);
        browseProjectsButton.setText("Browse...");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).indent(10, -1).applyTo((Control)browseProjectsButton);
        UIUtils.setDefaultButtonWidth(browseProjectsButton);
        browseProjectsButton.addSelectionListener(this.selectionListener);
    }

    public SelectProjectComponentBuilder setTextLabel(String label) {
        this.textLabel = label;
        return this;
    }

    public SelectProjectComponentBuilder setEclipseProjectObservable(IObservableValue<?> eclipseProjectObservable) {
        this.eclipseProjectObservable = eclipseProjectObservable;
        return this;
    }

    public SelectProjectComponentBuilder setHorisontalSpan(int hSpan) {
        this.hSpan = hSpan;
        return this;
    }

    public SelectProjectComponentBuilder setRequired(boolean required) {
        this.required = required;
        return this;
    }

    public SelectProjectComponentBuilder setSelectionListener(SelectionListener listener) {
        this.selectionListener = listener;
        return this;
    }

    public ISWTObservableValue getProjectNameTextObservable() {
        return this.projectNameTextObservable;
    }
}

