/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.connection;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizardModel;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizardPage;

public class ConnectionWizard
extends Wizard {
    private final ConnectionWizardPage page;
    public static final String NEW_CONNECTION_TITLE = "New OpenShift Connection";
    public static final String EDIT_CONNECTION_TITLE = "Edit OpenShift Connection";

    public ConnectionWizard() {
        this(ConnectionsRegistrySingleton.getInstance().getRecentConnection(), NEW_CONNECTION_TITLE);
    }

    public ConnectionWizard(String title) {
        this(ConnectionsRegistrySingleton.getInstance().getRecentConnection(), title);
    }

    public ConnectionWizard(IConnection connection) {
        this(connection, NEW_CONNECTION_TITLE);
    }

    public ConnectionWizard(IConnection connection, String title) {
        this(connection, null, title);
    }

    public ConnectionWizard(IConnection connection, Object context) {
        this(connection, context, NEW_CONNECTION_TITLE);
    }

    public ConnectionWizard(IConnection connection, Object context, String title) {
        this.page = new ConnectionWizardPage((IWizard)this, new ConnectionWizardModel(connection, context), false);
        this.setNeedsProgressMonitor(true);
        if (title != null) {
            this.setWindowTitle(title);
        }
    }

    public IConnection getConnection() {
        return this.page.getConnection();
    }

    public boolean performFinish() {
        return this.page.connect();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page);
    }
}

