/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core;

import com.openshift.restclient.ISSLCertificateCallback;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSession;
import org.jboss.tools.openshift.core.OpenShiftCoreUIIntegration;

public class LazySSLCertificateCallback
implements ISSLCertificateCallback {
    private ISSLCertificateCallback callback;

    public boolean allowCertificate(X509Certificate[] certs) {
        if (!this.loadCallback()) {
            return false;
        }
        return this.callback.allowCertificate(certs);
    }

    public boolean allowHostname(String hostname, SSLSession session) {
        if (!this.loadCallback()) {
            return false;
        }
        return this.callback.allowHostname(hostname, session);
    }

    private boolean loadCallback() {
        if (this.callback == null) {
            this.callback = this.getExtension();
            return this.callback != null;
        }
        return true;
    }

    public ISSLCertificateCallback getExtension() {
        return OpenShiftCoreUIIntegration.getInstance().getSSLCertificateCallback();
    }
}

