/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.connection;

import com.openshift.restclient.ClientBuilder;
import com.openshift.restclient.IClient;
import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.ISSLCertificateCallback;
import com.openshift.restclient.NotFoundException;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.authorization.IAuthorizationContext;
import com.openshift.restclient.authorization.UnauthorizedException;
import com.openshift.restclient.capability.ICapability;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IResourceBuilder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.common.core.ICredentialsPrompter;
import org.jboss.tools.openshift.common.core.IRefreshable;
import org.jboss.tools.openshift.common.core.connection.ConnectionType;
import org.jboss.tools.openshift.common.core.connection.ConnectionURL;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.IOpenShiftConnection;
import org.jboss.tools.openshift.core.preferences.OpenShiftCorePreferences;
import org.jboss.tools.openshift.internal.common.core.UsageStats;
import org.jboss.tools.openshift.internal.common.core.security.OpenShiftSecureStorageKey;
import org.jboss.tools.openshift.internal.common.core.security.SecureStore;
import org.jboss.tools.openshift.internal.common.core.security.SecureStoreException;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;

public class Connection
extends ObservablePojo
implements IRefreshable,
IOpenShiftConnection {
    public static final String SECURE_STORAGE_BASEKEY = "org.jboss.tools.openshift.core";
    public static final String SECURE_STORAGE_PASSWORD_KEY = "password";
    public static final String SECURE_STORAGE_TOKEN_KEY = "token";
    private IClient client;
    private boolean passwordLoaded = false;
    private boolean tokenLoaded = false;
    private boolean rememberPassword;
    private boolean rememberToken;
    private boolean promptCredentialsEnabled = true;
    private ICredentialsPrompter credentialsPrompter;
    private String authScheme;
    private Map<String, Object> extendedProperties = new HashMap<String, Object>();

    public Connection(String url, ICredentialsPrompter credentialsPrompter, ISSLCertificateCallback sslCertCallback) throws MalformedURLException {
        this(new ClientBuilder(url).sslCertificateCallback(sslCertCallback).build(), credentialsPrompter);
    }

    public Connection(IClient client, ICredentialsPrompter credentialsPrompter) {
        this.client = client;
        this.credentialsPrompter = credentialsPrompter;
    }

    @Override
    public Map<String, Object> getExtendedProperties() {
        return new HashMap<String, Object>(this.extendedProperties);
    }

    @Override
    public void setExtendedProperty(String name, Object value) {
        HashMap<String, Object> oldExt = new HashMap<String, Object>(this.extendedProperties);
        this.extendedProperties.put(name, value);
        this.firePropertyChange("extendedProperties", oldExt, this.extendedProperties);
    }

    @Override
    public void setExtendedProperties(Map<String, Object> ext) {
        this.extendedProperties = ext;
        this.firePropertyChange("extendedProperties", this.extendedProperties, this.extendedProperties);
    }

    @Override
    public String getClusterNamespace() {
        return (String)this.getExtendedProperties().getOrDefault("org.jbosstools.openshift.core.connection.ext.cluster.namespace", "openshift");
    }

    public IResourceFactory getResourceFactory() {
        return this.client.getResourceFactory();
    }

    public <B extends IResourceBuilder> B getResourceBuilder(Class<? extends ICapability> klass) {
        ICapability cap;
        if (this.client.supports(klass) && (cap = this.client.getCapability(klass)) instanceof IResourceBuilder) {
            return (B)((IResourceBuilder)cap);
        }
        return null;
    }

    @Override
    public String getUsername() {
        return this.client.getAuthorizationContext().getUserName();
    }

    public void setUsername(String userName) {
        IAuthorizationContext authContext = this.client.getAuthorizationContext();
        String old = authContext.getUserName();
        authContext.setUserName(userName);
        this.firePropertyChange("username", old, userName);
    }

    public String getPassword() {
        return this.loadAuthorizationContext().getPassword();
    }

    public void setPassword(String password) {
        IAuthorizationContext authContext = this.client.getAuthorizationContext();
        String old = authContext.getPassword();
        authContext.setPassword(password);
        this.firePropertyChange(SECURE_STORAGE_PASSWORD_KEY, old, password);
        this.passwordLoaded = true;
    }

    public void setRememberPassword(boolean rememberPassword) {
        this.rememberPassword = rememberPassword;
        this.firePropertyChange("rememberPassword", this.rememberPassword, this.rememberPassword);
    }

    public boolean isRememberPassword() {
        return this.rememberPassword;
    }

    public boolean isRememberToken() {
        return this.rememberToken;
    }

    public void setRememberToken(boolean rememberToken) {
        this.rememberToken = rememberToken;
        this.firePropertyChange("rememberToken", this.rememberToken, this.rememberToken);
    }

    public void enablePromptCredentials(boolean enable) {
        this.promptCredentialsEnabled = enable;
    }

    public boolean isEnablePromptCredentials() {
        return this.promptCredentialsEnabled;
    }

    public String getAuthScheme() {
        return StringUtils.defaultIfBlank((String)this.authScheme, (String)"OAuth");
    }

    protected String load(String id) {
        String value = null;
        SecureStore store = this.getSecureStore(this.getHost(), this.getUsername());
        if (store != null) {
            try {
                value = store.get(id);
            }
            catch (SecureStoreException e) {
                OpenShiftCoreActivator.pluginLog().logError(e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    private boolean saveOrClear(String id, String value, boolean saveOrClear) {
        block5: {
            SecureStore store = this.getSecureStore(this.getHost(), this.getUsername());
            if (store != null) {
                try {
                    if (saveOrClear && !org.jboss.tools.openshift.common.core.utils.StringUtils.isEmpty((String)value)) {
                        store.put(id, value);
                    } else {
                        store.remove(id);
                    }
                }
                catch (SecureStoreException e) {
                    this.firePropertyChange("secureStoreException", null, (Object)e);
                    OpenShiftCoreActivator.logError(NLS.bind((String)"Exception saving {0} for connection to {1}", (Object)id, (Object)this.getHost()), e);
                    if (!(e.getCause() instanceof StorageException)) break block5;
                    return false;
                }
            }
        }
        return true;
    }

    protected SecureStore getSecureStore(String host, String username) {
        return new SecureStore((SecureStore.IStoreKey)new OpenShiftSecureStorageKey(SECURE_STORAGE_BASEKEY, host, username));
    }

    public boolean connect() throws OpenShiftException {
        if (this.authorize()) {
            this.savePasswordOrToken();
            this.saveAuthSchemePreference();
            return true;
        }
        return false;
    }

    protected boolean authorize() {
        try {
            IAuthorizationContext context = this.loadAuthorizationContext();
            if (!context.isAuthorized() && this.credentialsPrompter != null && this.promptCredentialsEnabled) {
                this.credentialsPrompter.promptAndAuthenticate((IConnection)this, null);
            } else {
                this.updateCredentials(context);
            }
        }
        catch (UnauthorizedException e) {
            if (this.isEnablePromptCredentials() && this.credentialsPrompter != null) {
                this.credentialsPrompter.promptAndAuthenticate((IConnection)this, (Object)e.getAuthorizationDetails());
            }
            throw e;
        }
        return this.getToken() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IAuthorizationContext loadAuthorizationContext() {
        IAuthorizationContext context;
        IAuthorizationContext iAuthorizationContext = context = this.client.getAuthorizationContext();
        synchronized (iAuthorizationContext) {
            if (!this.passwordLoaded) {
                this.setPassword(this.load(SECURE_STORAGE_PASSWORD_KEY));
                this.setRememberPassword(context.getPassword() != null);
            }
            if (!this.tokenLoaded) {
                this.setToken(this.load(SECURE_STORAGE_TOKEN_KEY));
                this.setRememberToken(context.getToken() != null);
            }
        }
        return context;
    }

    private void savePasswordOrToken() {
        boolean success;
        if ("Basic".equals(this.getAuthScheme())) {
            boolean success2 = this.saveOrClear(SECURE_STORAGE_PASSWORD_KEY, this.client.getAuthorizationContext().getPassword(), this.isRememberPassword());
            if (success2) {
                this.clearToken();
            }
        } else if ("OAuth".equals(this.getAuthScheme()) && (success = this.saveOrClear(SECURE_STORAGE_TOKEN_KEY, this.client.getAuthorizationContext().getToken(), this.isRememberToken()))) {
            this.clearPassword();
        }
    }

    private void clearPassword() {
        this.client.getAuthorizationContext().setPassword(null);
        this.setRememberPassword(false);
        this.saveOrClear(SECURE_STORAGE_PASSWORD_KEY, null, false);
    }

    private void clearToken() {
        this.setRememberToken(false);
        this.saveOrClear(SECURE_STORAGE_TOKEN_KEY, null, false);
    }

    public void removeSecureStoreData() {
        SecureStore store = this.getSecureStore(this.getHost(), this.getUsername());
        if (store != null) {
            try {
                store.removeNode();
            }
            catch (SecureStoreException e) {
                this.firePropertyChange("secureStoreException", null, (Object)e);
                OpenShiftCoreActivator.logWarning(e.getMessage(), e);
            }
        }
    }

    protected void saveAuthSchemePreference() {
        ConnectionURL url = ConnectionURL.safeForConnection((IConnection)this);
        if (!org.jboss.tools.openshift.common.core.utils.StringUtils.isEmpty((Object)url)) {
            OpenShiftCorePreferences.INSTANCE.saveAuthScheme(url.toString(), this.getAuthScheme());
        }
    }

    private void updateCredentials(IAuthorizationContext context) {
        this.setToken(context.getToken());
        if ("OAuth".equalsIgnoreCase(this.getAuthScheme())) {
            this.setUsername(context.getUser().getName());
        }
    }

    public boolean isAuthorized(IProgressMonitor monitor) {
        try {
            IAuthorizationContext context = this.client.getAuthorizationContext();
            boolean result = context.isAuthorized();
            if (result) {
                return this.connect();
            }
            return result;
        }
        catch (UnauthorizedException unauthorizedException) {
            return false;
        }
    }

    public void setAuthScheme(String scheme) {
        this.authScheme = scheme;
        this.firePropertyChange("authtype", this.authScheme, this.authScheme);
    }

    public String getHost() {
        return this.client.getBaseURL().toString();
    }

    public boolean isDefaultHost() {
        return false;
    }

    public String getScheme() {
        return String.valueOf(this.client.getBaseURL().getProtocol()) + "://";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.client == null ? 0 : this.client.getBaseURL().toString().hashCode());
        if (this.client != null) {
            result = 31 * result + (this.client.getAuthorizationContext().getUserName() == null ? 0 : this.client.getAuthorizationContext().getUserName().hashCode());
        }
        return result;
    }

    public IConnection clone() {
        IClient clone = this.client.clone();
        Connection connection = new Connection(clone, this.credentialsPrompter);
        connection.passwordLoaded = this.passwordLoaded;
        connection.tokenLoaded = this.tokenLoaded;
        connection.rememberPassword = this.rememberPassword;
        connection.rememberToken = this.rememberToken;
        connection.promptCredentialsEnabled = this.promptCredentialsEnabled;
        return connection;
    }

    public void update(IConnection connection) {
        Assert.isLegal((boolean)(connection instanceof Connection));
        Connection otherConnection = (Connection)connection;
        this.client = otherConnection.client;
        this.credentialsPrompter = otherConnection.credentialsPrompter;
        this.rememberToken = otherConnection.rememberToken;
        this.rememberPassword = otherConnection.rememberPassword;
        this.tokenLoaded = otherConnection.tokenLoaded;
        this.rememberPassword = otherConnection.rememberPassword;
        this.extendedProperties = otherConnection.getExtendedProperties();
        IAuthorizationContext otherContext = otherConnection.client.getAuthorizationContext();
        IAuthorizationContext context = this.client.getAuthorizationContext();
        context.setUserName(otherContext.getUserName());
        context.setPassword(otherContext.getPassword());
        context.setToken(otherContext.getToken());
    }

    public void refresh() {
        this.connect();
    }

    public ConnectionType getType() {
        return ConnectionType.Kubernetes;
    }

    public String toString() {
        return this.client.getBaseURL().toString();
    }

    public <T extends IResource> T createResource(T resource) {
        try {
            return (T)this.client.create(resource);
        }
        catch (UnauthorizedException e) {
            return this.retryCreate((OpenShiftException)((Object)e), resource);
        }
    }

    public <T extends IResource> T updateResource(T resource) {
        try {
            return (T)this.client.update(resource);
        }
        catch (UnauthorizedException e) {
            return this.retryUpdate((OpenShiftException)((Object)e), resource);
        }
    }

    @Override
    public <T extends IResource> List<T> getResources(String kind) {
        return this.getResources(kind, "");
    }

    @Override
    public <T extends IResource> List<T> getResources(String kind, String namespace) {
        try {
            return this.client.list(kind, namespace);
        }
        catch (UnauthorizedException e) {
            return this.retryList((OpenShiftException)((Object)e), kind, namespace);
        }
    }

    @Override
    public <T extends IResource> T getResource(String kind, String namespace, String name) {
        try {
            return (T)this.client.get(kind, name, namespace);
        }
        catch (UnauthorizedException e) {
            return this.retryGet((OpenShiftException)((Object)e), kind, name, namespace);
        }
    }

    @Override
    public <T extends IResource> T refresh(IResource resource) {
        try {
            return (T)this.client.get(resource.getKind(), resource.getName(), resource.getNamespace());
        }
        catch (UnauthorizedException e) {
            return this.retryGet((OpenShiftException)((Object)e), resource.getKind(), resource.getName(), resource.getNamespace());
        }
    }

    private <T extends IResource> T retryGet(OpenShiftException e, String kind, String name, String namespace) {
        this.setToken(null);
        if (this.connect()) {
            return (T)this.client.get(kind, name, namespace);
        }
        throw e;
    }

    private <T extends IResource> T retryCreate(OpenShiftException e, T resource) {
        this.setToken(null);
        if (this.connect()) {
            return (T)this.client.create(resource);
        }
        throw e;
    }

    private <T extends IResource> T retryUpdate(OpenShiftException e, T resource) {
        this.setToken(null);
        if (this.connect()) {
            return (T)this.client.update(resource);
        }
        throw e;
    }

    private <T extends IResource> List<T> retryList(OpenShiftException e, String kind, String namespace) {
        this.setToken(null);
        if (this.connect()) {
            return this.client.list(kind, namespace);
        }
        throw e;
    }

    public void deleteResource(IResource resource) {
        this.client.delete(resource);
    }

    public boolean canConnect() throws IOException {
        try {
            this.client.getOpenShiftAPIVersion();
            return true;
        }
        catch (NotFoundException notFoundException) {
            return false;
        }
    }

    public String getToken() {
        return this.loadAuthorizationContext().getToken();
    }

    public void setToken(String token) {
        IAuthorizationContext context = this.client.getAuthorizationContext();
        String old = context.getToken();
        context.setToken(token);
        this.firePropertyChange(SECURE_STORAGE_TOKEN_KEY, old, token);
        this.tokenLoaded = true;
    }

    public void notifyUsage() {
        UsageStats.getInstance().newV3Connection(this.getHost());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Connection other = (Connection)obj;
        if (this.client == null ? other.client != null : other.client == null || !this.client.getBaseURL().toString().equals(other.client.getBaseURL().toString())) {
            return false;
        }
        return !(this.client.getAuthorizationContext().getUserName() == null ? other.client.getAuthorizationContext().getUserName() != null : !this.client.getAuthorizationContext().getUserName().equals(other.client.getAuthorizationContext().getUserName()));
    }

    public boolean credentialsEqual(IConnection connection) {
        if (!this.equals(connection)) {
            return false;
        }
        Connection other = (Connection)connection;
        if (!Objects.equals(this.client.getAuthorizationContext().getPassword(), other.client.getAuthorizationContext().getPassword())) {
            return false;
        }
        return Objects.equals(this.client.getAuthorizationContext().getToken(), other.client.getAuthorizationContext().getToken());
    }

    public boolean ownsResource(IResource resource) {
        if (resource == null) {
            return false;
        }
        return ObjectUtils.equals((Object)this.client, (Object)ResourceUtils.getClient(resource));
    }

    @Override
    public String getOpenShiftMasterVersion() {
        return this.client.getOpenshiftMasterVersion();
    }

    @Override
    public String getKubernetesMasterVersion() {
        return this.client.getKubernetesMasterVersion();
    }
}

