/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.connection;

import com.openshift.restclient.ClientBuilder;
import com.openshift.restclient.IClient;
import com.openshift.restclient.ISSLCertificateCallback;
import com.openshift.restclient.OpenShiftException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionFactory;
import org.jboss.tools.openshift.core.LazyCredentialsPrompter;
import org.jboss.tools.openshift.core.LazySSLCertificateCallback;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;

public class ConnectionFactory
implements IConnectionFactory {
    private static final String SIGNUP_URL = "https://manage.openshift.com/openshiftio";
    public static final String OPENSHIFT_USERDOC = "openshift.userdoc.url";

    public String getName() {
        return "OpenShift 3";
    }

    public String getId() {
        return "org.jboss.tools.openshift.core.ConnectionFactory";
    }

    public Connection create(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return null;
        }
        try {
            LazySSLCertificateCallback sslCertCallback = new LazySSLCertificateCallback();
            IClient client = new ClientBuilder(url).sslCertificateCallback((ISSLCertificateCallback)sslCertCallback).withMaxRequests(1000).withMaxRequestsPerHost(1000).build();
            return new Connection(client, new LazyCredentialsPrompter());
        }
        catch (OpenShiftException e) {
            OpenShiftCoreActivator.pluginLog().logInfo(NLS.bind((String)"Could not create OpenShift connection: Malformed url {0}", (Object)url), (Throwable)e);
            return null;
        }
    }

    public String getDefaultHost() {
        return null;
    }

    public boolean hasDefaultHost() {
        return false;
    }

    public <T extends IConnection> boolean canCreate(Class<T> clazz) {
        return Connection.class.isAssignableFrom(clazz);
    }

    public String getUserDocUrl() {
        return this.getSignupUrl();
    }

    private String getSignupUrl() {
        return SIGNUP_URL;
    }

    public String getUserDocText() {
        return "Want to try OpenShift 3 online? You can sign up for an account <a>here</a>";
    }
}

